# SystemLogApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**listLogEvents**](SystemLogApi.md#listLogEvents) | **GET** /api/v1/logs | List all System Log Events |



## listLogEvents

> List&lt;LogEvent&gt; listLogEvents(since, until, after, filter, q, limit, sortOrder)

List all System Log Events

Lists all System Log Events

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SystemLogApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SystemLogApi apiInstance = new SystemLogApi(defaultClient);
        String since = "7 days prior to until"; // String | Filters the lower time bound of the log events `published` property for bounded queries or persistence time for polling queries
        String until = "current time"; // String | Filters the upper time bound of the log events `published` property for bounded queries or persistence time for polling queries.
        String after = "after_example"; // String | Retrieves the next page of results. Okta returns a link in the HTTP Header (`rel=next`) that includes the after query parameter
        String filter = "filter_example"; // String | Filter expression that filters the results. All operators except [ ] are supported. See [Filter](https://developer.okta.com/docs/api/#filter).
        String q = "q_example"; // String | Filters log events results by one or more case insensitive keywords.
        Integer limit = 100; // Integer | Sets the number of results that are returned in the response
        String sortOrder = "ASCENDING"; // String | The order of the returned events that are sorted by the `published` property
        try {
            List<LogEvent> result = apiInstance.listLogEvents(since, until, after, filter, q, limit, sortOrder);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SystemLogApi#listLogEvents");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **since** | **String**| Filters the lower time bound of the log events &#x60;published&#x60; property for bounded queries or persistence time for polling queries | [optional] [default to 7 days prior to until] |
| **until** | **String**| Filters the upper time bound of the log events &#x60;published&#x60; property for bounded queries or persistence time for polling queries. | [optional] [default to current time] |
| **after** | **String**| Retrieves the next page of results. Okta returns a link in the HTTP Header (&#x60;rel&#x3D;next&#x60;) that includes the after query parameter | [optional] |
| **filter** | **String**| Filter expression that filters the results. All operators except [ ] are supported. See [Filter](https://developer.okta.com/docs/api/#filter). | [optional] |
| **q** | **String**| Filters log events results by one or more case insensitive keywords. | [optional] |
| **limit** | **Integer**| Sets the number of results that are returned in the response | [optional] [default to 100] |
| **sortOrder** | **String**| The order of the returned events that are sorted by the &#x60;published&#x60; property | [optional] [default to ASCENDING] [enum: ASCENDING, DESCENDING] |

### Return type

[**List&lt;LogEvent&gt;**](LogEvent.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

