# RoleDResourceSetBindingApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createResourceSetBinding**](RoleDResourceSetBindingApi.md#createResourceSetBinding) | **POST** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings | Create a Role Resource Set Binding |
| [**deleteBinding**](RoleDResourceSetBindingApi.md#deleteBinding) | **DELETE** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel} | Delete a Role Resource Set Binding |
| [**getBinding**](RoleDResourceSetBindingApi.md#getBinding) | **GET** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel} | Retrieve a Role Resource Set Binding |
| [**listBindings**](RoleDResourceSetBindingApi.md#listBindings) | **GET** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings | List all Role Resource Set Bindings |



## createResourceSetBinding

> ResourceSetBindingResponse createResourceSetBinding(resourceSetIdOrLabel, instance)

Create a Role Resource Set Binding

Creates a Binding for the Resource Set, Custom Role, and members (Users or Groups)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingApi apiInstance = new RoleDResourceSetBindingApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        ResourceSetBindingCreateRequest instance = new ResourceSetBindingCreateRequest(); // ResourceSetBindingCreateRequest | 
        try {
            ResourceSetBindingResponse result = apiInstance.createResourceSetBinding(resourceSetIdOrLabel, instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingApi#createResourceSetBinding");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **instance** | [**ResourceSetBindingCreateRequest**](ResourceSetBindingCreateRequest.md)|  | |

### Return type

[**ResourceSetBindingResponse**](ResourceSetBindingResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteBinding

> deleteBinding(resourceSetIdOrLabel, roleIdOrLabel)

Delete a Role Resource Set Binding

Deletes a Binding of a Role (identified by &#x60;roleIdOrLabel&#x60;) and a Resource Set (identified by &#x60;resourceSetIdOrLabel&#x60;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingApi apiInstance = new RoleDResourceSetBindingApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        try {
            apiInstance.deleteBinding(resourceSetIdOrLabel, roleIdOrLabel);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingApi#deleteBinding");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getBinding

> ResourceSetBindingResponse getBinding(resourceSetIdOrLabel, roleIdOrLabel)

Retrieve a Role Resource Set Binding

Retrieves the Binding of a Role (identified by &#x60;roleIdOrLabel&#x60;) in a Resource Set (identified by &#x60;resourceSetIdOrLabel&#x60;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingApi apiInstance = new RoleDResourceSetBindingApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        try {
            ResourceSetBindingResponse result = apiInstance.getBinding(resourceSetIdOrLabel, roleIdOrLabel);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingApi#getBinding");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |

### Return type

[**ResourceSetBindingResponse**](ResourceSetBindingResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listBindings

> ResourceSetBindings listBindings(resourceSetIdOrLabel, after)

List all Role Resource Set Bindings

Lists all Bindings for a Resource Set with pagination support

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingApi apiInstance = new RoleDResourceSetBindingApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        try {
            ResourceSetBindings result = apiInstance.listBindings(resourceSetIdOrLabel, after);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingApi#listBindings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |

### Return type

[**ResourceSetBindings**](ResourceSetBindings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

