# RoleCResourceSetResourceApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**addResourceSetResources**](RoleCResourceSetResourceApi.md#addResourceSetResources) | **PATCH** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources | Add more Resources to a Resource Set |
| [**deleteResourceSetResource**](RoleCResourceSetResourceApi.md#deleteResourceSetResource) | **DELETE** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources/{resourceId} | Delete a Resource Set Resource |
| [**listResourceSetResources**](RoleCResourceSetResourceApi.md#listResourceSetResources) | **GET** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources | List all Resource Set Resources |



## addResourceSetResources

> ResourceSet addResourceSetResources(resourceSetIdOrLabel, instance)

Add more Resources to a Resource Set

Adds more Resources to a Resource Set

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleCResourceSetResourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleCResourceSetResourceApi apiInstance = new RoleCResourceSetResourceApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        ResourceSetResourcePatchRequest instance = new ResourceSetResourcePatchRequest(); // ResourceSetResourcePatchRequest | 
        try {
            ResourceSet result = apiInstance.addResourceSetResources(resourceSetIdOrLabel, instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleCResourceSetResourceApi#addResourceSetResources");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **instance** | [**ResourceSetResourcePatchRequest**](ResourceSetResourcePatchRequest.md)|  | |

### Return type

[**ResourceSet**](ResourceSet.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteResourceSetResource

> deleteResourceSetResource(resourceSetIdOrLabel, resourceId)

Delete a Resource Set Resource

Deletes a Resource (identified by &#x60;resourceId&#x60;) from a Resource Set

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleCResourceSetResourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleCResourceSetResourceApi apiInstance = new RoleCResourceSetResourceApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String resourceId = "ire106sQKoHoXXsAe0g4"; // String | `id` of the Resource
        try {
            apiInstance.deleteResourceSetResource(resourceSetIdOrLabel, resourceId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleCResourceSetResourceApi#deleteResourceSetResource");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **resourceId** | **String**| &#x60;id&#x60; of the Resource | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listResourceSetResources

> ResourceSetResources listResourceSetResources(resourceSetIdOrLabel)

List all Resource Set Resources

Lists all Resources for the Resource Set

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleCResourceSetResourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleCResourceSetResourceApi apiInstance = new RoleCResourceSetResourceApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        try {
            ResourceSetResources result = apiInstance.listResourceSetResources(resourceSetIdOrLabel);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleCResourceSetResourceApi#listResourceSetResources");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |

### Return type

[**ResourceSetResources**](ResourceSetResources.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

