# RoleAssignmentClientApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignRoleToClient**](RoleAssignmentClientApi.md#assignRoleToClient) | **POST** /oauth2/v1/clients/{clientId}/roles | Assign a Client Role |
| [**deleteRoleFromClient**](RoleAssignmentClientApi.md#deleteRoleFromClient) | **DELETE** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId} | Unassign a Client Role |
| [**listRolesForClient**](RoleAssignmentClientApi.md#listRolesForClient) | **GET** /oauth2/v1/clients/{clientId}/roles | List all Client Role Assignments |
| [**retrieveClientRole**](RoleAssignmentClientApi.md#retrieveClientRole) | **GET** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId} | Retrieve a Client Role |



## assignRoleToClient

> ListGroupAssignedRoles200ResponseInner assignRoleToClient(clientId, assignRoleToGroupRequest)

Assign a Client Role

Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a Client Application.  You can also assign a custom role to a Client Application, but the preferred method to assign a custom role to a client is to create a binding between the Custom Role, the Resource Set, and the Client Application. See [Create a Role Resource Set Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).  &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For IAM-based standard role assignments, use the request payload for standard roles. However, the response payload for IAM-based role assignments is similar to the custom role&#39;s assignment response.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentClientApi apiInstance = new RoleAssignmentClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        AssignRoleToGroupRequest assignRoleToGroupRequest = new AssignRoleToGroupRequest(); // AssignRoleToGroupRequest | 
        try {
            ListGroupAssignedRoles200ResponseInner result = apiInstance.assignRoleToClient(clientId, assignRoleToGroupRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentClientApi#assignRoleToClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **assignRoleToGroupRequest** | [**AssignRoleToGroupRequest**](AssignRoleToGroupRequest.md)|  | |

### Return type

[**ListGroupAssignedRoles200ResponseInner**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteRoleFromClient

> deleteRoleFromClient(clientId, roleAssignmentId)

Unassign a Client Role

Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a Client Application (identified by &#x60;clientId&#x60;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentClientApi apiInstance = new RoleAssignmentClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        try {
            apiInstance.deleteRoleFromClient(clientId, roleAssignmentId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentClientApi#deleteRoleFromClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listRolesForClient

> ListGroupAssignedRoles200ResponseInner listRolesForClient(clientId)

List all Client Role Assignments

Lists all roles assigned to a Client Application identified  by &#x60;clientId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentClientApi apiInstance = new RoleAssignmentClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        try {
            ListGroupAssignedRoles200ResponseInner result = apiInstance.listRolesForClient(clientId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentClientApi#listRolesForClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |

### Return type

[**ListGroupAssignedRoles200ResponseInner**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## retrieveClientRole

> ListGroupAssignedRoles200ResponseInner retrieveClientRole(clientId, roleAssignmentId)

Retrieve a Client Role

Retrieves a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) for a Client Application (identified by &#x60;clientId&#x60;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentClientApi apiInstance = new RoleAssignmentClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        try {
            ListGroupAssignedRoles200ResponseInner result = apiInstance.retrieveClientRole(clientId, roleAssignmentId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentClientApi#retrieveClientRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |

### Return type

[**ListGroupAssignedRoles200ResponseInner**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

