# RoleAssignmentBGroupApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignRoleToGroup**](RoleAssignmentBGroupApi.md#assignRoleToGroup) | **POST** /api/v1/groups/{groupId}/roles | Assign a Role to a Group |
| [**getGroupAssignedRole**](RoleAssignmentBGroupApi.md#getGroupAssignedRole) | **GET** /api/v1/groups/{groupId}/roles/{roleAssignmentId} | Retrieve a Group Role Assignment |
| [**listGroupAssignedRoles**](RoleAssignmentBGroupApi.md#listGroupAssignedRoles) | **GET** /api/v1/groups/{groupId}/roles | List all Group Role Assignments |
| [**unassignRoleFromGroup**](RoleAssignmentBGroupApi.md#unassignRoleFromGroup) | **DELETE** /api/v1/groups/{groupId}/roles/{roleAssignmentId} | Unassign a Group Role |



## assignRoleToGroup

> ListGroupAssignedRoles200ResponseInner assignRoleToGroup(groupId, assignRoleRequest, disableNotifications)

Assign a Role to a Group

Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a Group.  You can also assign a custom role to a Group, but the preferred method to assign a custom role to a Group is to create a binding between the Custom Role, the Resource Set, and the Group. See [Create a Role Resource Set Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).  &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For IAM-based standard role assignments, use the request payload for standard roles. However, the response payload for IAM-based role assignments is similar to the custom role&#39;s assignment response.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentBGroupApi apiInstance = new RoleAssignmentBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        AssignRoleToGroupRequest assignRoleRequest = new AssignRoleToGroupRequest(); // AssignRoleToGroupRequest | 
        Boolean disableNotifications = false; // Boolean | Grants the Group third-party admin status when set to `true`
        try {
            ListGroupAssignedRoles200ResponseInner result = apiInstance.assignRoleToGroup(groupId, assignRoleRequest, disableNotifications);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentBGroupApi#assignRoleToGroup");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **assignRoleRequest** | [**AssignRoleToGroupRequest**](AssignRoleToGroupRequest.md)|  | |
| **disableNotifications** | **Boolean**| Grants the Group third-party admin status when set to &#x60;true&#x60; | [optional] [default to false] |

### Return type

[**ListGroupAssignedRoles200ResponseInner**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **201** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getGroupAssignedRole

> ListGroupAssignedRoles200ResponseInner getGroupAssignedRole(groupId, roleAssignmentId)

Retrieve a Group Role Assignment

Retrieves a Role assigned to a Group (identified by the &#x60;groupId&#x60;). The &#x60;roleAssignmentId&#x60; is the unique identifier for either a standard role Group Assignment object or a custom role Resource Set Binding object.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentBGroupApi apiInstance = new RoleAssignmentBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        try {
            ListGroupAssignedRoles200ResponseInner result = apiInstance.getGroupAssignedRole(groupId, roleAssignmentId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentBGroupApi#getGroupAssignedRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |

### Return type

[**ListGroupAssignedRoles200ResponseInner**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listGroupAssignedRoles

> List&lt;ListGroupAssignedRoles200ResponseInner&gt; listGroupAssignedRoles(groupId, expand)

List all Group Role Assignments

Lists all assigned roles of a Group by &#x60;groupId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentBGroupApi apiInstance = new RoleAssignmentBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String expand = "targets/groups"; // String | An optional parameter used to return targets configured for the standard Role Assignment in the `embedded` property. Supported values: `targets/groups` or `targets/catalog/apps`
        try {
            List<ListGroupAssignedRoles200ResponseInner> result = apiInstance.listGroupAssignedRoles(groupId, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentBGroupApi#listGroupAssignedRoles");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **expand** | **String**| An optional parameter used to return targets configured for the standard Role Assignment in the &#x60;embedded&#x60; property. Supported values: &#x60;targets/groups&#x60; or &#x60;targets/catalog/apps&#x60; | [optional] |

### Return type

[**List&lt;ListGroupAssignedRoles200ResponseInner&gt;**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignRoleFromGroup

> unassignRoleFromGroup(groupId, roleAssignmentId)

Unassign a Group Role

Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a Group (identified by the &#x60;groupId&#x60;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentBGroupApi apiInstance = new RoleAssignmentBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        try {
            apiInstance.unassignRoleFromGroup(groupId, roleAssignmentId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentBGroupApi#unassignRoleFromGroup");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

