# RoleAssignmentAUserApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignRoleToUser**](RoleAssignmentAUserApi.md#assignRoleToUser) | **POST** /api/v1/users/{userId}/roles | Assign a User Role |
| [**getUserAssignedRole**](RoleAssignmentAUserApi.md#getUserAssignedRole) | **GET** /api/v1/users/{userId}/roles/{roleAssignmentId} | Retrieve a User Role Assignment |
| [**listAssignedRolesForUser**](RoleAssignmentAUserApi.md#listAssignedRolesForUser) | **GET** /api/v1/users/{userId}/roles | List all User Role Assignments |
| [**listUsersWithRoleAssignments**](RoleAssignmentAUserApi.md#listUsersWithRoleAssignments) | **GET** /api/v1/iam/assignees/users | List all Users with Role Assignments |
| [**unassignRoleFromUser**](RoleAssignmentAUserApi.md#unassignRoleFromUser) | **DELETE** /api/v1/users/{userId}/roles/{roleAssignmentId} | Unassign a User Role |



## assignRoleToUser

> AssignRoleToUser201Response assignRoleToUser(userId, assignRoleRequest, disableNotifications)

Assign a User Role

Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a User.  You can also assign a custom role to a User, but the preferred method to assign a custom role to a User is to create a binding between the Custom Role, the Resource Set, and the User. See [Create a Role Resource Set Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).  &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For IAM-based standard role assignments, use the request payload for standard roles. However, the response payload for IAM-based role assignments is similar to the custom role&#39;s assignment response.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentAUserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentAUserApi apiInstance = new RoleAssignmentAUserApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        AssignRoleToUserRequest assignRoleRequest = new AssignRoleToUserRequest(); // AssignRoleToUserRequest | 
        Boolean disableNotifications = false; // Boolean | Setting this to `true` grants the User third-party admin status
        try {
            AssignRoleToUser201Response result = apiInstance.assignRoleToUser(userId, assignRoleRequest, disableNotifications);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentAUserApi#assignRoleToUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **assignRoleRequest** | [**AssignRoleToUserRequest**](AssignRoleToUserRequest.md)|  | |
| **disableNotifications** | **Boolean**| Setting this to &#x60;true&#x60; grants the User third-party admin status | [optional] [default to false] |

### Return type

[**AssignRoleToUser201Response**](AssignRoleToUser201Response.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getUserAssignedRole

> ListGroupAssignedRoles200ResponseInner getUserAssignedRole(userId, roleAssignmentId)

Retrieve a User Role Assignment

Retrieves a Role assigned to a User (identified by &#x60;userId&#x60;). The &#x60;roleAssignmentId&#x60; parameter is the unique identifier for either a standard Role Assignment object or a custom role Resource Set Binding object.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentAUserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentAUserApi apiInstance = new RoleAssignmentAUserApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        try {
            ListGroupAssignedRoles200ResponseInner result = apiInstance.getUserAssignedRole(userId, roleAssignmentId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentAUserApi#getUserAssignedRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |

### Return type

[**ListGroupAssignedRoles200ResponseInner**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listAssignedRolesForUser

> List&lt;ListGroupAssignedRoles200ResponseInner&gt; listAssignedRolesForUser(userId, expand)

List all User Role Assignments

Lists all roles assigned to a User (identified by &#x60;userId&#x60;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentAUserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentAUserApi apiInstance = new RoleAssignmentAUserApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String expand = "targets/groups"; // String | An optional parameter used to return targets configured for the standard Role Assignment in the `embedded` property. Supported values: `targets/groups` or `targets/catalog/apps`
        try {
            List<ListGroupAssignedRoles200ResponseInner> result = apiInstance.listAssignedRolesForUser(userId, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentAUserApi#listAssignedRolesForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **expand** | **String**| An optional parameter used to return targets configured for the standard Role Assignment in the &#x60;embedded&#x60; property. Supported values: &#x60;targets/groups&#x60; or &#x60;targets/catalog/apps&#x60; | [optional] |

### Return type

[**List&lt;ListGroupAssignedRoles200ResponseInner&gt;**](ListGroupAssignedRoles200ResponseInner.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listUsersWithRoleAssignments

> RoleAssignedUsers listUsersWithRoleAssignments(after, limit)

List all Users with Role Assignments

Lists all users with Role Assignments

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentAUserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentAUserApi apiInstance = new RoleAssignmentAUserApi(defaultClient);
        String after = "after_example"; // String | Specifies the pagination cursor for the next page of targets
        Integer limit = 100; // Integer | Specifies the number of results returned. Defaults to `100`.
        try {
            RoleAssignedUsers result = apiInstance.listUsersWithRoleAssignments(after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentAUserApi#listUsersWithRoleAssignments");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **after** | **String**| Specifies the pagination cursor for the next page of targets | [optional] |
| **limit** | **Integer**| Specifies the number of results returned. Defaults to &#x60;100&#x60;. | [optional] [default to 100] |

### Return type

[**RoleAssignedUsers**](RoleAssignedUsers.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## unassignRoleFromUser

> unassignRoleFromUser(userId, roleAssignmentId)

Unassign a User Role

Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a User (identified by &#x60;userId&#x60;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleAssignmentAUserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleAssignmentAUserApi apiInstance = new RoleAssignmentAUserApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        try {
            apiInstance.unassignRoleFromUser(userId, roleAssignmentId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleAssignmentAUserApi#unassignRoleFromUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

