

# PolicySubject

Specifies the behavior for establishing, validating, and matching a username for an IdP User

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**filter** | **String** | Optional [regular expression pattern](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Regular_expressions) used to filter untrusted IdP usernames. * As a best security practice, you should define a regular expression pattern to filter untrusted IdP usernames. This is especially important if multiple IdPs are connected to your org. The filter prevents an IdP from issuing an assertion for any User, including partners or directory Users in your Okta org. * For example, the filter pattern &#x60;(\\S+@example\\.com)&#x60; allows only Users that have an &#x60;@example.com&#x60; username suffix. It rejects assertions that have any other suffix such as &#x60;@corp.example.com&#x60; or &#x60;@partner.com&#x60;. * Only &#x60;SAML2&#x60; and &#x60;OIDC&#x60; IdP providers support the &#x60;filter&#x60; property. |  [optional] |
|**matchAttribute** | **String** | Okta User profile attribute for matching a transformed IdP username. Only for matchType &#x60;CUSTOM_ATTRIBUTE&#x60;. The &#x60;matchAttribute&#x60; must be a valid Okta User profile attribute of one of the following types: * String (with no format or &#39;email&#39; format only) * Integer * Number |  [optional] |
|**matchType** | **PolicySubjectMatchType** |  |  [optional] |
|**userNameTemplate** | [**PolicyUserNameTemplate**](PolicyUserNameTemplate.md) |  |  [optional] |


## Implemented Interfaces

* Serializable


