# OrgSettingAdminApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignClientPrivilegesSetting**](OrgSettingAdminApi.md#assignClientPrivilegesSetting) | **PUT** /api/v1/org/settings/clientPrivilegesSetting | Assign the Default Public Client App Role Setting |
| [**getClientPrivilegesSetting**](OrgSettingAdminApi.md#getClientPrivilegesSetting) | **GET** /api/v1/org/settings/clientPrivilegesSetting | Retrieve the Default Public Client App Role Setting |
| [**getThirdPartyAdminSetting**](OrgSettingAdminApi.md#getThirdPartyAdminSetting) | **GET** /api/v1/org/orgSettings/thirdPartyAdminSetting | Retrieve the Org Third-Party Admin Setting |
| [**updateThirdPartyAdminSetting**](OrgSettingAdminApi.md#updateThirdPartyAdminSetting) | **POST** /api/v1/org/orgSettings/thirdPartyAdminSetting | Update the Org Third-Party Admin Setting |



## assignClientPrivilegesSetting

> ClientPrivilegesSetting assignClientPrivilegesSetting(clientPrivilegesSetting)

Assign the Default Public Client App Role Setting

Assigns the [Super Admin role](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext_superadmin) as the default role for new public client apps

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.OrgSettingAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        OrgSettingAdminApi apiInstance = new OrgSettingAdminApi(defaultClient);
        ClientPrivilegesSetting clientPrivilegesSetting = new ClientPrivilegesSetting(); // ClientPrivilegesSetting | 
        try {
            ClientPrivilegesSetting result = apiInstance.assignClientPrivilegesSetting(clientPrivilegesSetting);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling OrgSettingAdminApi#assignClientPrivilegesSetting");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientPrivilegesSetting** | [**ClientPrivilegesSetting**](ClientPrivilegesSetting.md)|  | [optional] |

### Return type

[**ClientPrivilegesSetting**](ClientPrivilegesSetting.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## getClientPrivilegesSetting

> ClientPrivilegesSetting getClientPrivilegesSetting()

Retrieve the Default Public Client App Role Setting

Retrieves the org setting to assign the [Super Admin role](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext_superadmin) to new public client apps

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.OrgSettingAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        OrgSettingAdminApi apiInstance = new OrgSettingAdminApi(defaultClient);
        try {
            ClientPrivilegesSetting result = apiInstance.getClientPrivilegesSetting();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling OrgSettingAdminApi#getClientPrivilegesSetting");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**ClientPrivilegesSetting**](ClientPrivilegesSetting.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## getThirdPartyAdminSetting

> ThirdPartyAdminSetting getThirdPartyAdminSetting()

Retrieve the Org Third-Party Admin Setting

Retrieves the Third-Party Admin Setting. See [Configure third-party administrators](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;csh_admin-third) in the Okta product documentation.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.OrgSettingAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        OrgSettingAdminApi apiInstance = new OrgSettingAdminApi(defaultClient);
        try {
            ThirdPartyAdminSetting result = apiInstance.getThirdPartyAdminSetting();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling OrgSettingAdminApi#getThirdPartyAdminSetting");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**ThirdPartyAdminSetting**](ThirdPartyAdminSetting.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## updateThirdPartyAdminSetting

> ThirdPartyAdminSetting updateThirdPartyAdminSetting(thirdPartyAdminSetting)

Update the Org Third-Party Admin Setting

Updates the Third-Party Admin Setting. This setting allows third-party admins to perform administrative actions in the Admin Console, but they can&#39;t do any of the following:   * Receive Okta admin email notifications   * Contact Okta support   * Sign in to the Okta Help Center  See [Configure third-party administrators](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;csh_admin-third) in the Okta product documentation. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.OrgSettingAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        OrgSettingAdminApi apiInstance = new OrgSettingAdminApi(defaultClient);
        ThirdPartyAdminSetting thirdPartyAdminSetting = new ThirdPartyAdminSetting(); // ThirdPartyAdminSetting | 
        try {
            ThirdPartyAdminSetting result = apiInstance.updateThirdPartyAdminSetting(thirdPartyAdminSetting);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling OrgSettingAdminApi#updateThirdPartyAdminSetting");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **thirdPartyAdminSetting** | [**ThirdPartyAdminSetting**](ThirdPartyAdminSetting.md)|  | |

### Return type

[**ThirdPartyAdminSetting**](ThirdPartyAdminSetting.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

