# IdentitySourceApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createIdentitySourceSession**](IdentitySourceApi.md#createIdentitySourceSession) | **POST** /api/v1/identity-sources/{identitySourceId}/sessions | Create an Identity Source Session |
| [**deleteIdentitySourceSession**](IdentitySourceApi.md#deleteIdentitySourceSession) | **DELETE** /api/v1/identity-sources/{identitySourceId}/sessions/{sessionId} | Delete an Identity Source Session |
| [**getIdentitySourceSession**](IdentitySourceApi.md#getIdentitySourceSession) | **GET** /api/v1/identity-sources/{identitySourceId}/sessions/{sessionId} | Retrieve an Identity Source Session |
| [**listIdentitySourceSessions**](IdentitySourceApi.md#listIdentitySourceSessions) | **GET** /api/v1/identity-sources/{identitySourceId}/sessions | List all Identity Source Sessions |
| [**startImportFromIdentitySource**](IdentitySourceApi.md#startImportFromIdentitySource) | **POST** /api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/start-import | Start the import from the Identity Source |
| [**uploadIdentitySourceDataForDelete**](IdentitySourceApi.md#uploadIdentitySourceDataForDelete) | **POST** /api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-delete | Upload the data to be deleted in Okta |
| [**uploadIdentitySourceDataForUpsert**](IdentitySourceApi.md#uploadIdentitySourceDataForUpsert) | **POST** /api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-upsert | Upload the data to be upserted in Okta |



## createIdentitySourceSession

> IdentitySourceSession createIdentitySourceSession(identitySourceId)

Create an Identity Source Session

Creates an Identity Source Session for the given Identity Source instance

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentitySourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentitySourceApi apiInstance = new IdentitySourceApi(defaultClient);
        String identitySourceId = "0oa3l6l6WK6h0R0QW0g4"; // String | The ID of the Identity Source for which the session is created
        try {
            IdentitySourceSession result = apiInstance.createIdentitySourceSession(identitySourceId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentitySourceApi#createIdentitySourceSession");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identitySourceId** | **String**| The ID of the Identity Source for which the session is created | |

### Return type

[**IdentitySourceSession**](IdentitySourceSession.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteIdentitySourceSession

> deleteIdentitySourceSession(identitySourceId, sessionId)

Delete an Identity Source Session

Deletes an Identity Source Session for a given &#x60;identitySourceId&#x60; and &#x60;sessionId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentitySourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentitySourceApi apiInstance = new IdentitySourceApi(defaultClient);
        String identitySourceId = "0oa3l6l6WK6h0R0QW0g4"; // String | The ID of the Identity Source for which the session is created
        String sessionId = "aps1qqonvr2SZv6o70h8"; // String | The ID of the Identity Source Session
        try {
            apiInstance.deleteIdentitySourceSession(identitySourceId, sessionId);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentitySourceApi#deleteIdentitySourceSession");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identitySourceId** | **String**| The ID of the Identity Source for which the session is created | |
| **sessionId** | **String**| The ID of the Identity Source Session | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getIdentitySourceSession

> IdentitySourceSession getIdentitySourceSession(identitySourceId, sessionId)

Retrieve an Identity Source Session

Retrieves an Identity Source Session for a given Identity Source ID and session ID

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentitySourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentitySourceApi apiInstance = new IdentitySourceApi(defaultClient);
        String identitySourceId = "0oa3l6l6WK6h0R0QW0g4"; // String | The ID of the Identity Source for which the session is created
        String sessionId = "aps1qqonvr2SZv6o70h8"; // String | The ID of the Identity Source Session
        try {
            IdentitySourceSession result = apiInstance.getIdentitySourceSession(identitySourceId, sessionId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentitySourceApi#getIdentitySourceSession");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identitySourceId** | **String**| The ID of the Identity Source for which the session is created | |
| **sessionId** | **String**| The ID of the Identity Source Session | |

### Return type

[**IdentitySourceSession**](IdentitySourceSession.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listIdentitySourceSessions

> List&lt;IdentitySourceSession&gt; listIdentitySourceSessions(identitySourceId)

List all Identity Source Sessions

Lists all Identity Source Sessions for the given Identity Source instance

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentitySourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentitySourceApi apiInstance = new IdentitySourceApi(defaultClient);
        String identitySourceId = "0oa3l6l6WK6h0R0QW0g4"; // String | The ID of the Identity Source for which the session is created
        try {
            List<IdentitySourceSession> result = apiInstance.listIdentitySourceSessions(identitySourceId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentitySourceApi#listIdentitySourceSessions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identitySourceId** | **String**| The ID of the Identity Source for which the session is created | |

### Return type

[**List&lt;IdentitySourceSession&gt;**](IdentitySourceSession.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## startImportFromIdentitySource

> IdentitySourceSession startImportFromIdentitySource(identitySourceId, sessionId)

Start the import from the Identity Source

Starts the import from the Identity Source described by the uploaded bulk operations

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentitySourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentitySourceApi apiInstance = new IdentitySourceApi(defaultClient);
        String identitySourceId = "0oa3l6l6WK6h0R0QW0g4"; // String | The ID of the Identity Source for which the session is created
        String sessionId = "aps1qqonvr2SZv6o70h8"; // String | The ID of the Identity Source Session
        try {
            IdentitySourceSession result = apiInstance.startImportFromIdentitySource(identitySourceId, sessionId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentitySourceApi#startImportFromIdentitySource");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identitySourceId** | **String**| The ID of the Identity Source for which the session is created | |
| **sessionId** | **String**| The ID of the Identity Source Session | |

### Return type

[**IdentitySourceSession**](IdentitySourceSession.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## uploadIdentitySourceDataForDelete

> uploadIdentitySourceDataForDelete(identitySourceId, sessionId, bulkDeleteRequestBody)

Upload the data to be deleted in Okta

Uploads external IDs of entities that need to be deleted in Okta from the Identity Source for the given session

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentitySourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentitySourceApi apiInstance = new IdentitySourceApi(defaultClient);
        String identitySourceId = "0oa3l6l6WK6h0R0QW0g4"; // String | The ID of the Identity Source for which the session is created
        String sessionId = "aps1qqonvr2SZv6o70h8"; // String | The ID of the Identity Source Session
        BulkDeleteRequestBody bulkDeleteRequestBody = new BulkDeleteRequestBody(); // BulkDeleteRequestBody | 
        try {
            apiInstance.uploadIdentitySourceDataForDelete(identitySourceId, sessionId, bulkDeleteRequestBody);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentitySourceApi#uploadIdentitySourceDataForDelete");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identitySourceId** | **String**| The ID of the Identity Source for which the session is created | |
| **sessionId** | **String**| The ID of the Identity Source Session | |
| **bulkDeleteRequestBody** | [**BulkDeleteRequestBody**](BulkDeleteRequestBody.md)|  | [optional] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **202** | Accepted |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## uploadIdentitySourceDataForUpsert

> uploadIdentitySourceDataForUpsert(identitySourceId, sessionId, bulkUpsertRequestBody)

Upload the data to be upserted in Okta

Uploads entities that need to be inserted or updated in Okta from the Identity Source for the given session

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentitySourceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentitySourceApi apiInstance = new IdentitySourceApi(defaultClient);
        String identitySourceId = "0oa3l6l6WK6h0R0QW0g4"; // String | The ID of the Identity Source for which the session is created
        String sessionId = "aps1qqonvr2SZv6o70h8"; // String | The ID of the Identity Source Session
        BulkUpsertRequestBody bulkUpsertRequestBody = new BulkUpsertRequestBody(); // BulkUpsertRequestBody | 
        try {
            apiInstance.uploadIdentitySourceDataForUpsert(identitySourceId, sessionId, bulkUpsertRequestBody);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentitySourceApi#uploadIdentitySourceDataForUpsert");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identitySourceId** | **String**| The ID of the Identity Source for which the session is created | |
| **sessionId** | **String**| The ID of the Identity Source Session | |
| **bulkUpsertRequestBody** | [**BulkUpsertRequestBody**](BulkUpsertRequestBody.md)|  | [optional] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **202** | Accepted |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

