

# ECKeyJWK

Elliptic Curve Key in JWK format, currently used during enrollment to encrypt fulfillment requests to Yubico, or during activation to verify Yubico's JWS objects in fulfillment responses. The currently agreed protocol uses P-384.

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**crv** | [**CrvEnum**](#CrvEnum) |  |  |
|**kid** | **String** | The unique identifier of the key |  |
|**kty** | [**KtyEnum**](#KtyEnum) | The type of public key |  |
|**use** | [**UseEnum**](#UseEnum) | The intended use for the key. The ECKeyJWK is always &#x60;enc&#x60; because Okta uses it to encrypt requests to Yubico. |  |
|**x** | **String** | The public x coordinate for the elliptic curve point |  |
|**y** | **String** | The public y coordinate for the elliptic curve point |  |



## Enum: CrvEnum

| Name | Value |
|---- | -----|
| P_384 | &quot;P-384&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: KtyEnum

| Name | Value |
|---- | -----|
| EC | &quot;EC&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: UseEnum

| Name | Value |
|---- | -----|
| ENC | &quot;enc&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |


## Implemented Interfaces

* Serializable


