# AttackProtectionApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getAuthenticatorSettings**](AttackProtectionApi.md#getAuthenticatorSettings) | **GET** /attack-protection/api/v1/authenticator-settings | Retrieve the Authenticator Settings |
| [**getUserLockoutSettings**](AttackProtectionApi.md#getUserLockoutSettings) | **GET** /attack-protection/api/v1/user-lockout-settings | Retrieve the User Lockout Settings |
| [**replaceAuthenticatorSettings**](AttackProtectionApi.md#replaceAuthenticatorSettings) | **PUT** /attack-protection/api/v1/authenticator-settings | Replace the Authenticator Settings |
| [**replaceUserLockoutSettings**](AttackProtectionApi.md#replaceUserLockoutSettings) | **PUT** /attack-protection/api/v1/user-lockout-settings | Replace the User Lockout Settings |



## getAuthenticatorSettings

> List&lt;AttackProtectionAuthenticatorSettings&gt; getAuthenticatorSettings()

Retrieve the Authenticator Settings

Retrieves the Authenticator Settings for an org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AttackProtectionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AttackProtectionApi apiInstance = new AttackProtectionApi(defaultClient);
        try {
            List<AttackProtectionAuthenticatorSettings> result = apiInstance.getAuthenticatorSettings();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AttackProtectionApi#getAuthenticatorSettings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;AttackProtectionAuthenticatorSettings&gt;**](AttackProtectionAuthenticatorSettings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## getUserLockoutSettings

> List&lt;UserLockoutSettings&gt; getUserLockoutSettings()

Retrieve the User Lockout Settings

Retrieves the User Lockout Settings for an org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AttackProtectionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AttackProtectionApi apiInstance = new AttackProtectionApi(defaultClient);
        try {
            List<UserLockoutSettings> result = apiInstance.getUserLockoutSettings();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AttackProtectionApi#getUserLockoutSettings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;UserLockoutSettings&gt;**](UserLockoutSettings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceAuthenticatorSettings

> AttackProtectionAuthenticatorSettings replaceAuthenticatorSettings(authenticatorSettings)

Replace the Authenticator Settings

Replaces the Authenticator Settings for an org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AttackProtectionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AttackProtectionApi apiInstance = new AttackProtectionApi(defaultClient);
        AttackProtectionAuthenticatorSettings authenticatorSettings = new AttackProtectionAuthenticatorSettings(); // AttackProtectionAuthenticatorSettings | 
        try {
            AttackProtectionAuthenticatorSettings result = apiInstance.replaceAuthenticatorSettings(authenticatorSettings);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AttackProtectionApi#replaceAuthenticatorSettings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authenticatorSettings** | [**AttackProtectionAuthenticatorSettings**](AttackProtectionAuthenticatorSettings.md)|  | |

### Return type

[**AttackProtectionAuthenticatorSettings**](AttackProtectionAuthenticatorSettings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceUserLockoutSettings

> UserLockoutSettings replaceUserLockoutSettings(lockoutSettings)

Replace the User Lockout Settings

Replaces the User Lockout Settings for an org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AttackProtectionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AttackProtectionApi apiInstance = new AttackProtectionApi(defaultClient);
        UserLockoutSettings lockoutSettings = new UserLockoutSettings(); // UserLockoutSettings | 
        try {
            UserLockoutSettings result = apiInstance.replaceUserLockoutSettings(lockoutSettings);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AttackProtectionApi#replaceUserLockoutSettings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lockoutSettings** | [**UserLockoutSettings**](UserLockoutSettings.md)|  | |

### Return type

[**UserLockoutSettings**](UserLockoutSettings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

