package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserTypeLinks;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserType
 */
@JsonPropertyOrder({ UserType.JSON_PROPERTY_CREATED, UserType.JSON_PROPERTY_CREATED_BY, UserType.JSON_PROPERTY_DEFAULT,
        UserType.JSON_PROPERTY_DESCRIPTION, UserType.JSON_PROPERTY_DISPLAY_NAME, UserType.JSON_PROPERTY_ID,
        UserType.JSON_PROPERTY_LAST_UPDATED, UserType.JSON_PROPERTY_LAST_UPDATED_BY, UserType.JSON_PROPERTY_NAME,
        UserType.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserType implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;

    public static final String JSON_PROPERTY_DEFAULT = "default";
    private Boolean _default;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserTypeLinks links;

    public UserType() {
    }

    /*
     * @JsonCreator public UserType(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy,
     *
     * @JsonProperty(JSON_PROPERTY_DEFAULT) Boolean _default,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY) String lastUpdatedBy ) { this(); this.created = created;
     * this.createdBy = createdBy; this._default = _default; this.lastUpdated = lastUpdated; this.lastUpdatedBy =
     * lastUpdatedBy; }
     */

    /**
     * A timestamp from when the User Type was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A timestamp from when the User Type was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * The user ID of the account that created the User Type
     *
     * @return createdBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user ID of the account that created the User Type")
    @JsonProperty(JSON_PROPERTY_CREATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }

    /**
     * A boolean value to indicate if this is the default User Type
     *
     * @return _default
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A boolean value to indicate if this is the default User Type")
    @JsonProperty(JSON_PROPERTY_DEFAULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getDefault() {
        return _default;
    }

    public UserType description(String description) {

        this.description = description;
        return this;
    }

    /**
     * The human-readable description of the User Type
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The human-readable description of the User Type")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UserType displayName(String displayName) {

        this.displayName = displayName;
        return this;
    }

    /**
     * The human-readable name of the User Type
     *
     * @return displayName
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The human-readable name of the User Type")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserType id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique key for the User Type
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique key for the User Type")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    /**
     * A timestamp from when the User Type was most recently updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A timestamp from when the User Type was most recently updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    /**
     * The user ID of the most recent account to edit the User Type
     *
     * @return lastUpdatedBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user ID of the most recent account to edit the User Type")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedBy() {
        return lastUpdatedBy;
    }

    public UserType name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name of the User Type. The name must start with A-Z or a-z and contain only A-Z, a-z, 0-9, or underscore (_)
     * characters. This value becomes read-only after creation and can&#39;t be updated.
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The name of the User Type. The name must start with A-Z or a-z and contain only A-Z, a-z, 0-9, or underscore (_) characters. This value becomes read-only after creation and can't be updated.")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UserType links(UserTypeLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserTypeLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserTypeLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserType userType = (UserType) o;
        return Objects.equals(this.created, userType.created) && Objects.equals(this.createdBy, userType.createdBy)
                && Objects.equals(this._default, userType._default)
                && Objects.equals(this.description, userType.description)
                && Objects.equals(this.displayName, userType.displayName) && Objects.equals(this.id, userType.id)
                && Objects.equals(this.lastUpdated, userType.lastUpdated)
                && Objects.equals(this.lastUpdatedBy, userType.lastUpdatedBy)
                && Objects.equals(this.name, userType.name) && Objects.equals(this.links, userType.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, createdBy, _default, description, displayName, id, lastUpdated, lastUpdatedBy,
                name, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserType {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    lastUpdatedBy: ").append(toIndentedString(lastUpdatedBy)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
