package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the default and custom profile properties for a user. The default user profile is based on the [System for
 * Cross-domain Identity Management: Core Schema](https://datatracker.ietf.org/doc/html/rfc7643). The only permitted
 * customizations of the default profile are to update permissions, change whether the &#x60;firstName&#x60; and
 * &#x60;lastName&#x60; properties are nullable, and specify a
 * [pattern](https://developer.okta.com/docs/reference/api/schemas/#login-pattern-validation) for &#x60;login&#x60;. You
 * can use the Profile Editor in the Admin Console or the [Schemas
 * API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) to make
 * schema modifications. You can extend user profiles with custom properties. You must first add the custom property to
 * the user profile schema before you reference it. You can use the Profile Editor in the Admin console or the [Schemas
 * API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) to manage
 * schema extensions. Custom attributes can contain HTML tags. It&#39;s the client&#39;s responsibility to escape or
 * encode this data before displaying it. Use
 * [best-practices](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html) to
 * prevent cross-site scripting.
 */
@ApiModel(description = "Specifies the default and custom profile properties for a user.  The default user profile is based on the [System for Cross-domain Identity Management: Core Schema](https://datatracker.ietf.org/doc/html/rfc7643).  The only permitted customizations of the default profile are to update permissions, change whether the `firstName` and `lastName` properties are nullable, and specify a [pattern](https://developer.okta.com/docs/reference/api/schemas/#login-pattern-validation) for `login`. You can use the Profile Editor in the Admin Console or the [Schemas API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) to make schema modifications.  You can extend user profiles with custom properties. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin console or the [Schemas API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) to manage schema extensions.  Custom attributes can contain HTML tags. It's the client's responsibility to escape or encode this data before displaying it. Use [best-practices](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html) to prevent cross-site scripting.")
@JsonPropertyOrder({ UserProfile.JSON_PROPERTY_CITY, UserProfile.JSON_PROPERTY_COST_CENTER,
        UserProfile.JSON_PROPERTY_COUNTRY_CODE, UserProfile.JSON_PROPERTY_DEPARTMENT,
        UserProfile.JSON_PROPERTY_DISPLAY_NAME, UserProfile.JSON_PROPERTY_DIVISION, UserProfile.JSON_PROPERTY_EMAIL,
        UserProfile.JSON_PROPERTY_EMPLOYEE_NUMBER, UserProfile.JSON_PROPERTY_FIRST_NAME,
        UserProfile.JSON_PROPERTY_HONORIFIC_PREFIX, UserProfile.JSON_PROPERTY_HONORIFIC_SUFFIX,
        UserProfile.JSON_PROPERTY_LAST_NAME, UserProfile.JSON_PROPERTY_LOCALE, UserProfile.JSON_PROPERTY_LOGIN,
        UserProfile.JSON_PROPERTY_MANAGER, UserProfile.JSON_PROPERTY_MANAGER_ID, UserProfile.JSON_PROPERTY_MIDDLE_NAME,
        UserProfile.JSON_PROPERTY_MOBILE_PHONE, UserProfile.JSON_PROPERTY_NICK_NAME,
        UserProfile.JSON_PROPERTY_ORGANIZATION, UserProfile.JSON_PROPERTY_POSTAL_ADDRESS,
        UserProfile.JSON_PROPERTY_PREFERRED_LANGUAGE, UserProfile.JSON_PROPERTY_PRIMARY_PHONE,
        UserProfile.JSON_PROPERTY_PROFILE_URL, UserProfile.JSON_PROPERTY_SECOND_EMAIL, UserProfile.JSON_PROPERTY_STATE,
        UserProfile.JSON_PROPERTY_STREET_ADDRESS, UserProfile.JSON_PROPERTY_TIMEZONE, UserProfile.JSON_PROPERTY_TITLE,
        UserProfile.JSON_PROPERTY_USER_TYPE, UserProfile.JSON_PROPERTY_ZIP_CODE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public Map<String, Object> additionalProperties = new java.util.LinkedHashMap<>();

    public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public static final String JSON_PROPERTY_CITY = "city";
    private JsonNullable<String> city = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_COST_CENTER = "costCenter";
    private JsonNullable<String> costCenter = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private JsonNullable<String> countryCode = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_DEPARTMENT = "department";
    private String department;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_DIVISION = "division";
    private JsonNullable<String> division = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;

    public static final String JSON_PROPERTY_EMPLOYEE_NUMBER = "employeeNumber";
    private String employeeNumber;

    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private JsonNullable<String> firstName = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_HONORIFIC_PREFIX = "honorificPrefix";
    private JsonNullable<String> honorificPrefix = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_HONORIFIC_SUFFIX = "honorificSuffix";
    private JsonNullable<String> honorificSuffix = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private JsonNullable<String> lastName = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;

    public static final String JSON_PROPERTY_MANAGER = "manager";
    private JsonNullable<String> manager = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_MANAGER_ID = "managerId";
    private JsonNullable<String> managerId = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_MIDDLE_NAME = "middleName";
    private JsonNullable<String> middleName = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_MOBILE_PHONE = "mobilePhone";
    private JsonNullable<String> mobilePhone = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_NICK_NAME = "nickName";
    private JsonNullable<String> nickName = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private JsonNullable<String> organization = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_POSTAL_ADDRESS = "postalAddress";
    private JsonNullable<String> postalAddress = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_PREFERRED_LANGUAGE = "preferredLanguage";
    private JsonNullable<String> preferredLanguage = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_PRIMARY_PHONE = "primaryPhone";
    private JsonNullable<String> primaryPhone = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_PROFILE_URL = "profileUrl";
    private JsonNullable<String> profileUrl = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_SECOND_EMAIL = "secondEmail";
    private JsonNullable<String> secondEmail = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_STATE = "state";
    private JsonNullable<String> state = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_STREET_ADDRESS = "streetAddress";
    private JsonNullable<String> streetAddress = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private JsonNullable<String> timezone = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_TITLE = "title";
    private JsonNullable<String> title = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_USER_TYPE = "userType";
    private JsonNullable<String> userType = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_ZIP_CODE = "zipCode";
    private JsonNullable<String> zipCode = JsonNullable.<String> undefined();

    public UserProfile() {
    }

    public UserProfile city(String city) {
        this.city = JsonNullable.<String> of(city);

        return this;
    }

    /**
     * The city or locality of the User&#39;s address (&#x60;locality&#x60;)
     *
     * @return city
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The city or locality of the User's address (`locality`)")
    @JsonIgnore

    public String getCity() {
        return city.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_CITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getCity_JsonNullable() {
        return city;
    }

    @JsonProperty(JSON_PROPERTY_CITY)
    public void setCity_JsonNullable(JsonNullable<String> city) {
        this.city = city;
    }

    public void setCity(String city) {
        this.city = JsonNullable.<String> of(city);
    }

    public UserProfile costCenter(String costCenter) {
        this.costCenter = JsonNullable.<String> of(costCenter);

        return this;
    }

    /**
     * Name of the cost center assigned to a user
     *
     * @return costCenter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the cost center assigned to a user")
    @JsonIgnore

    public String getCostCenter() {
        return costCenter.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_COST_CENTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getCostCenter_JsonNullable() {
        return costCenter;
    }

    @JsonProperty(JSON_PROPERTY_COST_CENTER)
    public void setCostCenter_JsonNullable(JsonNullable<String> costCenter) {
        this.costCenter = costCenter;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = JsonNullable.<String> of(costCenter);
    }

    public UserProfile countryCode(String countryCode) {
        this.countryCode = JsonNullable.<String> of(countryCode);

        return this;
    }

    /**
     * The country name component of the User&#39;s address (&#x60;country&#x60;). For validation, see [ISO 3166-1 alpha
     * 2 \&quot;short\&quot; code
     * format](https://datatracker.ietf.org/doc/html/draft-ietf-scim-core-schema-22#ref-ISO3166).
     *
     * @return countryCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The country name component of the User's address (`country`). For validation, see [ISO 3166-1 alpha 2 \"short\" code format](https://datatracker.ietf.org/doc/html/draft-ietf-scim-core-schema-22#ref-ISO3166).")
    @JsonIgnore

    public String getCountryCode() {
        return countryCode.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getCountryCode_JsonNullable() {
        return countryCode;
    }

    @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
    public void setCountryCode_JsonNullable(JsonNullable<String> countryCode) {
        this.countryCode = countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = JsonNullable.<String> of(countryCode);
    }

    public UserProfile department(String department) {

        this.department = department;
        return this;
    }

    /**
     * Name of the User&#39;s department
     *
     * @return department
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the User's department")
    @JsonProperty(JSON_PROPERTY_DEPARTMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDepartment() {
        return department;
    }

    @JsonProperty(JSON_PROPERTY_DEPARTMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDepartment(String department) {
        this.department = department;
    }

    public UserProfile displayName(String displayName) {
        this.displayName = JsonNullable.<String> of(displayName);

        return this;
    }

    /**
     * Name of the User suitable for display to end users
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the User suitable for display to end users")
    @JsonIgnore

    public String getDisplayName() {
        return displayName.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getDisplayName_JsonNullable() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.<String> of(displayName);
    }

    public UserProfile division(String division) {
        this.division = JsonNullable.<String> of(division);

        return this;
    }

    /**
     * Name of the User&#39;s division
     *
     * @return division
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the User's division")
    @JsonIgnore

    public String getDivision() {
        return division.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_DIVISION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getDivision_JsonNullable() {
        return division;
    }

    @JsonProperty(JSON_PROPERTY_DIVISION)
    public void setDivision_JsonNullable(JsonNullable<String> division) {
        this.division = division;
    }

    public void setDivision(String division) {
        this.division = JsonNullable.<String> of(division);
    }

    public UserProfile email(String email) {

        this.email = email;
        return this;
    }

    /**
     * The primary email address of the user. For validation, see [RFC 5322 Section
     * 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).
     *
     * @return email
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The primary email address of the user. For validation, see [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).")
    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEmail() {
        return email;
    }

    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public UserProfile employeeNumber(String employeeNumber) {

        this.employeeNumber = employeeNumber;
        return this;
    }

    /**
     * The organization or company assigned unique identifier for the user
     *
     * @return employeeNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The organization or company assigned unique identifier for the user")
    @JsonProperty(JSON_PROPERTY_EMPLOYEE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEmployeeNumber() {
        return employeeNumber;
    }

    @JsonProperty(JSON_PROPERTY_EMPLOYEE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public UserProfile firstName(String firstName) {
        this.firstName = JsonNullable.<String> of(firstName);

        return this;
    }

    /**
     * Given name of the User (&#x60;givenName&#x60;)
     *
     * @return firstName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Given name of the User (`givenName`)")
    @JsonIgnore

    public String getFirstName() {
        return firstName.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getFirstName_JsonNullable() {
        return firstName;
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    public void setFirstName_JsonNullable(JsonNullable<String> firstName) {
        this.firstName = firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = JsonNullable.<String> of(firstName);
    }

    public UserProfile honorificPrefix(String honorificPrefix) {
        this.honorificPrefix = JsonNullable.<String> of(honorificPrefix);

        return this;
    }

    /**
     * Honorific prefix(es) of the user, or title in most Western languages
     *
     * @return honorificPrefix
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Honorific prefix(es) of the user, or title in most Western languages")
    @JsonIgnore

    public String getHonorificPrefix() {
        return honorificPrefix.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_HONORIFIC_PREFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getHonorificPrefix_JsonNullable() {
        return honorificPrefix;
    }

    @JsonProperty(JSON_PROPERTY_HONORIFIC_PREFIX)
    public void setHonorificPrefix_JsonNullable(JsonNullable<String> honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
    }

    public void setHonorificPrefix(String honorificPrefix) {
        this.honorificPrefix = JsonNullable.<String> of(honorificPrefix);
    }

    public UserProfile honorificSuffix(String honorificSuffix) {
        this.honorificSuffix = JsonNullable.<String> of(honorificSuffix);

        return this;
    }

    /**
     * Honorific suffix(es) of the User
     *
     * @return honorificSuffix
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Honorific suffix(es) of the User")
    @JsonIgnore

    public String getHonorificSuffix() {
        return honorificSuffix.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_HONORIFIC_SUFFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getHonorificSuffix_JsonNullable() {
        return honorificSuffix;
    }

    @JsonProperty(JSON_PROPERTY_HONORIFIC_SUFFIX)
    public void setHonorificSuffix_JsonNullable(JsonNullable<String> honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
    }

    public void setHonorificSuffix(String honorificSuffix) {
        this.honorificSuffix = JsonNullable.<String> of(honorificSuffix);
    }

    public UserProfile lastName(String lastName) {
        this.lastName = JsonNullable.<String> of(lastName);

        return this;
    }

    /**
     * The family name of the User (&#x60;familyName&#x60;)
     *
     * @return lastName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The family name of the User (`familyName`)")
    @JsonIgnore

    public String getLastName() {
        return lastName.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getLastName_JsonNullable() {
        return lastName;
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    public void setLastName_JsonNullable(JsonNullable<String> lastName) {
        this.lastName = lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = JsonNullable.<String> of(lastName);
    }

    public UserProfile locale(String locale) {

        this.locale = locale;
        return this;
    }

    /**
     * The User&#39;s default location for purposes of localizing items such as currency, date time format, numerical
     * representations, and so on. A locale value is a concatenation of the ISO 639-1 two-letter language code, an
     * underscore, and the ISO 3166-1 two-letter country code. For example, en_US specifies the language English and
     * country US. This value is &#x60;en_US&#x60; by default.
     *
     * @return locale
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The User's default location for purposes of localizing items such as currency, date time format, numerical representations, and so on. A locale value is a concatenation of the ISO 639-1 two-letter language code, an underscore, and the ISO 3166-1 two-letter country code. For example, en_US specifies the language English and country US. This value is `en_US` by default.")
    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLocale() {
        return locale;
    }

    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public UserProfile login(String login) {

        this.login = login;
        return this;
    }

    /**
     * The unique identifier for the User (&#x60;username&#x60;). For validation, see [Login pattern
     * validation](https://developer.okta.com/docs/reference/api/schemas/#login-pattern-validation). Every user within
     * your Okta org must have a unique identifier for a login. This constraint applies to all users you import from
     * other systems or applications such as Active Directory. Your organization is the top-level namespace to mix and
     * match logins from all your connected applications or directories. Careful consideration of naming conventions for
     * your login identifier will make it easier to onboard new applications in the future. Logins are not considered
     * unique if they differ only in case and/or diacritical marks. If one of your users has a login of
     * Isaac.Brock@example.com, there cannot be another user whose login is isaac.brock@example.com, nor
     * isáàc.bröck@example.com. Okta has a default ambiguous name resolution policy for usernames that include @-signs.
     * (By default, usernames must be formatted as email addresses and thus always include @-signs. You can remove that
     * restriction using either the Admin Console or the Schemas API (opens new window).) Users can sign in with their
     * non-qualified short name (for example: isaac.brock with username isaac.brock@example.com) as long as the short
     * name is still unique within the organization. maxLength: 100
     *
     * @return login
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier for the User (`username`). For validation, see [Login pattern validation](https://developer.okta.com/docs/reference/api/schemas/#login-pattern-validation).  Every user within your Okta org must have a unique identifier for a login. This constraint applies to all users you import from other systems or applications such as Active Directory. Your organization is the top-level namespace to mix and match logins from all your connected applications or directories. Careful consideration of naming conventions for your login identifier will make it easier to onboard new applications in the future.  Logins are not considered unique if they differ only in case and/or diacritical marks. If one of your users has a login of Isaac.Brock@example.com, there cannot be another user whose login is isaac.brock@example.com, nor isáàc.bröck@example.com.  Okta has a default ambiguous name resolution policy for usernames that include @-signs. (By default, usernames must be formatted as email addresses and thus always include @-signs. You can remove that restriction using either the Admin Console or the Schemas API (opens new window).) Users can sign in with their non-qualified short name (for example: isaac.brock with username isaac.brock@example.com) as long as the short name is still unique within the organization. maxLength: 100")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogin() {
        return login;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(String login) {
        this.login = login;
    }

    public UserProfile manager(String manager) {
        this.manager = JsonNullable.<String> of(manager);

        return this;
    }

    /**
     * The &#x60;displayName&#x60; of the User&#39;s manager
     *
     * @return manager
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `displayName` of the User's manager")
    @JsonIgnore

    public String getManager() {
        return manager.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MANAGER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getManager_JsonNullable() {
        return manager;
    }

    @JsonProperty(JSON_PROPERTY_MANAGER)
    public void setManager_JsonNullable(JsonNullable<String> manager) {
        this.manager = manager;
    }

    public void setManager(String manager) {
        this.manager = JsonNullable.<String> of(manager);
    }

    public UserProfile managerId(String managerId) {
        this.managerId = JsonNullable.<String> of(managerId);

        return this;
    }

    /**
     * The &#x60;id&#x60; of the User&#39;s manager
     *
     * @return managerId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `id` of the User's manager")
    @JsonIgnore

    public String getManagerId() {
        return managerId.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MANAGER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getManagerId_JsonNullable() {
        return managerId;
    }

    @JsonProperty(JSON_PROPERTY_MANAGER_ID)
    public void setManagerId_JsonNullable(JsonNullable<String> managerId) {
        this.managerId = managerId;
    }

    public void setManagerId(String managerId) {
        this.managerId = JsonNullable.<String> of(managerId);
    }

    public UserProfile middleName(String middleName) {
        this.middleName = JsonNullable.<String> of(middleName);

        return this;
    }

    /**
     * The middle name of the user
     *
     * @return middleName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The middle name of the user")
    @JsonIgnore

    public String getMiddleName() {
        return middleName.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MIDDLE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getMiddleName_JsonNullable() {
        return middleName;
    }

    @JsonProperty(JSON_PROPERTY_MIDDLE_NAME)
    public void setMiddleName_JsonNullable(JsonNullable<String> middleName) {
        this.middleName = middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = JsonNullable.<String> of(middleName);
    }

    public UserProfile mobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.<String> of(mobilePhone);

        return this;
    }

    /**
     * The mobile phone number of the user
     *
     * @return mobilePhone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The mobile phone number of the user")
    @JsonIgnore

    public String getMobilePhone() {
        return mobilePhone.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getMobilePhone_JsonNullable() {
        return mobilePhone;
    }

    @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
    public void setMobilePhone_JsonNullable(JsonNullable<String> mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.<String> of(mobilePhone);
    }

    public UserProfile nickName(String nickName) {
        this.nickName = JsonNullable.<String> of(nickName);

        return this;
    }

    /**
     * The casual way to address the User in real life
     *
     * @return nickName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The casual way to address the User in real life")
    @JsonIgnore

    public String getNickName() {
        return nickName.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_NICK_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getNickName_JsonNullable() {
        return nickName;
    }

    @JsonProperty(JSON_PROPERTY_NICK_NAME)
    public void setNickName_JsonNullable(JsonNullable<String> nickName) {
        this.nickName = nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = JsonNullable.<String> of(nickName);
    }

    public UserProfile organization(String organization) {
        this.organization = JsonNullable.<String> of(organization);

        return this;
    }

    /**
     * Name of the the User&#39;s organization
     *
     * @return organization
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the the User's organization")
    @JsonIgnore

    public String getOrganization() {
        return organization.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ORGANIZATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getOrganization_JsonNullable() {
        return organization;
    }

    @JsonProperty(JSON_PROPERTY_ORGANIZATION)
    public void setOrganization_JsonNullable(JsonNullable<String> organization) {
        this.organization = organization;
    }

    public void setOrganization(String organization) {
        this.organization = JsonNullable.<String> of(organization);
    }

    public UserProfile postalAddress(String postalAddress) {
        this.postalAddress = JsonNullable.<String> of(postalAddress);

        return this;
    }

    /**
     * Mailing address component of the User&#39;s address
     *
     * @return postalAddress
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Mailing address component of the User's address")
    @JsonIgnore

    public String getPostalAddress() {
        return postalAddress.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_POSTAL_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getPostalAddress_JsonNullable() {
        return postalAddress;
    }

    @JsonProperty(JSON_PROPERTY_POSTAL_ADDRESS)
    public void setPostalAddress_JsonNullable(JsonNullable<String> postalAddress) {
        this.postalAddress = postalAddress;
    }

    public void setPostalAddress(String postalAddress) {
        this.postalAddress = JsonNullable.<String> of(postalAddress);
    }

    public UserProfile preferredLanguage(String preferredLanguage) {
        this.preferredLanguage = JsonNullable.<String> of(preferredLanguage);

        return this;
    }

    /**
     * The User&#39;s preferred written or spoken language. For validation, see [RFC 7231 Section
     * 5.3.5](https://datatracker.ietf.org/doc/html/rfc7231#section-5.3.5).
     *
     * @return preferredLanguage
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The User's preferred written or spoken language. For validation, see [RFC 7231 Section 5.3.5](https://datatracker.ietf.org/doc/html/rfc7231#section-5.3.5).")
    @JsonIgnore

    public String getPreferredLanguage() {
        return preferredLanguage.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PREFERRED_LANGUAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getPreferredLanguage_JsonNullable() {
        return preferredLanguage;
    }

    @JsonProperty(JSON_PROPERTY_PREFERRED_LANGUAGE)
    public void setPreferredLanguage_JsonNullable(JsonNullable<String> preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = JsonNullable.<String> of(preferredLanguage);
    }

    public UserProfile primaryPhone(String primaryPhone) {
        this.primaryPhone = JsonNullable.<String> of(primaryPhone);

        return this;
    }

    /**
     * The primary phone number of the User such as a home number
     *
     * @return primaryPhone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The primary phone number of the User such as a home number")
    @JsonIgnore

    public String getPrimaryPhone() {
        return primaryPhone.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY_PHONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getPrimaryPhone_JsonNullable() {
        return primaryPhone;
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY_PHONE)
    public void setPrimaryPhone_JsonNullable(JsonNullable<String> primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    public void setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = JsonNullable.<String> of(primaryPhone);
    }

    public UserProfile profileUrl(String profileUrl) {
        this.profileUrl = JsonNullable.<String> of(profileUrl);

        return this;
    }

    /**
     * The URL of the User&#39;s online profile. For example, a web page. See
     * [URL](https://datatracker.ietf.org/doc/html/rfc1808).
     *
     * @return profileUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The URL of the User's online profile. For example, a web page. See [URL](https://datatracker.ietf.org/doc/html/rfc1808).")
    @JsonIgnore

    public String getProfileUrl() {
        return profileUrl.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PROFILE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getProfileUrl_JsonNullable() {
        return profileUrl;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE_URL)
    public void setProfileUrl_JsonNullable(JsonNullable<String> profileUrl) {
        this.profileUrl = profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = JsonNullable.<String> of(profileUrl);
    }

    public UserProfile secondEmail(String secondEmail) {
        this.secondEmail = JsonNullable.<String> of(secondEmail);

        return this;
    }

    /**
     * The secondary email address of the User typically used for account recovery. For validation, see [RFC 5322
     * Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).
     *
     * @return secondEmail
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The secondary email address of the User typically used for account recovery. For validation, see [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).")
    @JsonIgnore

    public String getSecondEmail() {
        return secondEmail.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_SECOND_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getSecondEmail_JsonNullable() {
        return secondEmail;
    }

    @JsonProperty(JSON_PROPERTY_SECOND_EMAIL)
    public void setSecondEmail_JsonNullable(JsonNullable<String> secondEmail) {
        this.secondEmail = secondEmail;
    }

    public void setSecondEmail(String secondEmail) {
        this.secondEmail = JsonNullable.<String> of(secondEmail);
    }

    public UserProfile state(String state) {
        this.state = JsonNullable.<String> of(state);

        return this;
    }

    /**
     * The state or region component of the User&#39;s address (&#x60;region&#x60;)
     *
     * @return state
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The state or region component of the User's address (`region`)")
    @JsonIgnore

    public String getState() {
        return state.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getState_JsonNullable() {
        return state;
    }

    @JsonProperty(JSON_PROPERTY_STATE)
    public void setState_JsonNullable(JsonNullable<String> state) {
        this.state = state;
    }

    public void setState(String state) {
        this.state = JsonNullable.<String> of(state);
    }

    public UserProfile streetAddress(String streetAddress) {
        this.streetAddress = JsonNullable.<String> of(streetAddress);

        return this;
    }

    /**
     * The full street address component of the User&#39;s address
     *
     * @return streetAddress
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The full street address component of the User's address")
    @JsonIgnore

    public String getStreetAddress() {
        return streetAddress.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_STREET_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getStreetAddress_JsonNullable() {
        return streetAddress;
    }

    @JsonProperty(JSON_PROPERTY_STREET_ADDRESS)
    public void setStreetAddress_JsonNullable(JsonNullable<String> streetAddress) {
        this.streetAddress = streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = JsonNullable.<String> of(streetAddress);
    }

    public UserProfile timezone(String timezone) {
        this.timezone = JsonNullable.<String> of(timezone);

        return this;
    }

    /**
     * The User&#39;s time zone
     *
     * @return timezone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The User's time zone")
    @JsonIgnore

    public String getTimezone() {
        return timezone.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getTimezone_JsonNullable() {
        return timezone;
    }

    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    public void setTimezone_JsonNullable(JsonNullable<String> timezone) {
        this.timezone = timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = JsonNullable.<String> of(timezone);
    }

    public UserProfile title(String title) {
        this.title = JsonNullable.<String> of(title);

        return this;
    }

    /**
     * The User&#39;s title, such as Vice President
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The User's title, such as Vice President")
    @JsonIgnore

    public String getTitle() {
        return title.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getTitle_JsonNullable() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    public void setTitle_JsonNullable(JsonNullable<String> title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.title = JsonNullable.<String> of(title);
    }

    public UserProfile userType(String userType) {
        this.userType = JsonNullable.<String> of(userType);

        return this;
    }

    /**
     * The property used to describe the organization-to-user relationship, such as employee or contractor
     *
     * @return userType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The property used to describe the organization-to-user relationship, such as employee or contractor")
    @JsonIgnore

    public String getUserType() {
        return userType.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_USER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getUserType_JsonNullable() {
        return userType;
    }

    @JsonProperty(JSON_PROPERTY_USER_TYPE)
    public void setUserType_JsonNullable(JsonNullable<String> userType) {
        this.userType = userType;
    }

    public void setUserType(String userType) {
        this.userType = JsonNullable.<String> of(userType);
    }

    public UserProfile zipCode(String zipCode) {
        this.zipCode = JsonNullable.<String> of(zipCode);

        return this;
    }

    /**
     * The ZIP code or postal code component of the User&#39;s address (&#x60;postalCode&#x60;)
     *
     * @return zipCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ZIP code or postal code component of the User's address (`postalCode`)")
    @JsonIgnore

    public String getZipCode() {
        return zipCode.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ZIP_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getZipCode_JsonNullable() {
        return zipCode;
    }

    @JsonProperty(JSON_PROPERTY_ZIP_CODE)
    public void setZipCode_JsonNullable(JsonNullable<String> zipCode) {
        this.zipCode = zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = JsonNullable.<String> of(zipCode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserProfile userProfile = (UserProfile) o;
        return equalsNullable(this.city, userProfile.city) && equalsNullable(this.costCenter, userProfile.costCenter)
                && equalsNullable(this.countryCode, userProfile.countryCode)
                && Objects.equals(this.department, userProfile.department)
                && equalsNullable(this.displayName, userProfile.displayName)
                && equalsNullable(this.division, userProfile.division) && Objects.equals(this.email, userProfile.email)
                && Objects.equals(this.employeeNumber, userProfile.employeeNumber)
                && equalsNullable(this.firstName, userProfile.firstName)
                && equalsNullable(this.honorificPrefix, userProfile.honorificPrefix)
                && equalsNullable(this.honorificSuffix, userProfile.honorificSuffix)
                && equalsNullable(this.lastName, userProfile.lastName)
                && Objects.equals(this.locale, userProfile.locale) && Objects.equals(this.login, userProfile.login)
                && equalsNullable(this.manager, userProfile.manager)
                && equalsNullable(this.managerId, userProfile.managerId)
                && equalsNullable(this.middleName, userProfile.middleName)
                && equalsNullable(this.mobilePhone, userProfile.mobilePhone)
                && equalsNullable(this.nickName, userProfile.nickName)
                && equalsNullable(this.organization, userProfile.organization)
                && equalsNullable(this.postalAddress, userProfile.postalAddress)
                && equalsNullable(this.preferredLanguage, userProfile.preferredLanguage)
                && equalsNullable(this.primaryPhone, userProfile.primaryPhone)
                && equalsNullable(this.profileUrl, userProfile.profileUrl)
                && equalsNullable(this.secondEmail, userProfile.secondEmail)
                && equalsNullable(this.state, userProfile.state)
                && equalsNullable(this.streetAddress, userProfile.streetAddress)
                && equalsNullable(this.timezone, userProfile.timezone) && equalsNullable(this.title, userProfile.title)
                && equalsNullable(this.userType, userProfile.userType)
                && equalsNullable(this.zipCode, userProfile.zipCode);
        // && super.equals(o);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(city), hashCodeNullable(costCenter), hashCodeNullable(countryCode),
                department, hashCodeNullable(displayName), hashCodeNullable(division), email, employeeNumber,
                hashCodeNullable(firstName), hashCodeNullable(honorificPrefix), hashCodeNullable(honorificSuffix),
                hashCodeNullable(lastName), locale, login, hashCodeNullable(manager), hashCodeNullable(managerId),
                hashCodeNullable(middleName), hashCodeNullable(mobilePhone), hashCodeNullable(nickName),
                hashCodeNullable(organization), hashCodeNullable(postalAddress), hashCodeNullable(preferredLanguage),
                hashCodeNullable(primaryPhone), hashCodeNullable(profileUrl), hashCodeNullable(secondEmail),
                hashCodeNullable(state), hashCodeNullable(streetAddress), hashCodeNullable(timezone),
                hashCodeNullable(title), hashCodeNullable(userType), hashCodeNullable(zipCode), super.hashCode());
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserProfile {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    city: ").append(toIndentedString(city)).append("\n");
        sb.append("    costCenter: ").append(toIndentedString(costCenter)).append("\n");
        sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
        sb.append("    department: ").append(toIndentedString(department)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    division: ").append(toIndentedString(division)).append("\n");
        sb.append("    email: ").append(toIndentedString(email)).append("\n");
        sb.append("    employeeNumber: ").append(toIndentedString(employeeNumber)).append("\n");
        sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
        sb.append("    honorificPrefix: ").append(toIndentedString(honorificPrefix)).append("\n");
        sb.append("    honorificSuffix: ").append(toIndentedString(honorificSuffix)).append("\n");
        sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
        sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    manager: ").append(toIndentedString(manager)).append("\n");
        sb.append("    managerId: ").append(toIndentedString(managerId)).append("\n");
        sb.append("    middleName: ").append(toIndentedString(middleName)).append("\n");
        sb.append("    mobilePhone: ").append(toIndentedString(mobilePhone)).append("\n");
        sb.append("    nickName: ").append(toIndentedString(nickName)).append("\n");
        sb.append("    organization: ").append(toIndentedString(organization)).append("\n");
        sb.append("    postalAddress: ").append(toIndentedString(postalAddress)).append("\n");
        sb.append("    preferredLanguage: ").append(toIndentedString(preferredLanguage)).append("\n");
        sb.append("    primaryPhone: ").append(toIndentedString(primaryPhone)).append("\n");
        sb.append("    profileUrl: ").append(toIndentedString(profileUrl)).append("\n");
        sb.append("    secondEmail: ").append(toIndentedString(secondEmail)).append("\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("    streetAddress: ").append(toIndentedString(streetAddress)).append("\n");
        sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    userType: ").append(toIndentedString(userType)).append("\n");
        sb.append("    zipCode: ").append(toIndentedString(zipCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
