package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserImportResponseCommandsInner;
import com.okta.sdk.resource.model.UserImportResponseError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserImportResponse
 */
@JsonPropertyOrder({ UserImportResponse.JSON_PROPERTY_COMMANDS, UserImportResponse.JSON_PROPERTY_ERROR })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserImportResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_COMMANDS = "commands";
    private List<UserImportResponseCommandsInner> commands = null;

    public static final String JSON_PROPERTY_ERROR = "error";
    private UserImportResponseError error;

    public UserImportResponse() {
    }

    public UserImportResponse commands(List<UserImportResponseCommandsInner> commands) {

        this.commands = commands;
        return this;
    }

    public UserImportResponse addcommandsItem(UserImportResponseCommandsInner commandsItem) {
        if (this.commands == null) {
            this.commands = new ArrayList<>();
        }
        this.commands.add(commandsItem);
        return this;
    }

    /**
     * The &#x60;commands&#x60; object is where you can provide commands to Okta. It is an array that allows you to send
     * multiple commands. Each array element needs to consist of a type-value pair.
     *
     * @return commands
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `commands` object is where you can provide commands to Okta. It is an array that allows you to send multiple commands. Each array element needs to consist of a type-value pair.")
    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<UserImportResponseCommandsInner> getCommands() {
        return commands;
    }

    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCommands(List<UserImportResponseCommandsInner> commands) {
        this.commands = commands;
    }

    public UserImportResponse error(UserImportResponseError error) {

        this.error = error;
        return this;
    }

    /**
     * Get error
     *
     * @return error
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserImportResponseError getError() {
        return error;
    }

    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setError(UserImportResponseError error) {
        this.error = error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportResponse userImportResponse = (UserImportResponse) o;
        return Objects.equals(this.commands, userImportResponse.commands)
                && Objects.equals(this.error, userImportResponse.error);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(commands, error);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportResponse {\n");
        sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
        sb.append("    error: ").append(toIndentedString(error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
