package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorActivateRequest
 */
@JsonPropertyOrder({ UserFactorActivateRequest.JSON_PROPERTY_PASS_CODE,
        UserFactorActivateRequest.JSON_PROPERTY_REGISTRATION_DATA, UserFactorActivateRequest.JSON_PROPERTY_ATTESTATION,
        UserFactorActivateRequest.JSON_PROPERTY_CLIENT_DATA })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserFactorActivateRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASS_CODE = "passCode";
    private String passCode;

    public static final String JSON_PROPERTY_REGISTRATION_DATA = "registrationData";
    private String registrationData;

    public static final String JSON_PROPERTY_ATTESTATION = "attestation";
    private String attestation;

    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;

    public UserFactorActivateRequest() {
    }

    public UserFactorActivateRequest passCode(String passCode) {

        this.passCode = passCode;
        return this;
    }

    /**
     * OTP for the current time window
     *
     * @return passCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "1234567890", value = "OTP for the current time window")
    @JsonProperty(JSON_PROPERTY_PASS_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPassCode() {
        return passCode;
    }

    @JsonProperty(JSON_PROPERTY_PASS_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassCode(String passCode) {
        this.passCode = passCode;
    }

    public UserFactorActivateRequest registrationData(String registrationData) {

        this.registrationData = registrationData;
        return this;
    }

    /**
     * Get registrationData
     *
     * @return registrationData
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REGISTRATION_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRegistrationData() {
        return registrationData;
    }

    @JsonProperty(JSON_PROPERTY_REGISTRATION_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationData(String registrationData) {
        this.registrationData = registrationData;
    }

    public UserFactorActivateRequest attestation(String attestation) {

        this.attestation = attestation;
        return this;
    }

    /**
     * Base64-encoded attestation from the WebAuthn authenticator
     *
     * @return attestation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "o2NmbXRmcGFja2VkZ2F0dFN0bXSiY2FsZyZjc2lnWEgwRgIhAMvf2+dzXlHZN1um38Y8aFzrKvX0k5dt/hnDu9lahbR4AiEAuwtMg3IoaElWMp00QrP/+3Po/6LwXfmYQVfsnsQ+da1oYXV0aERhdGFYxkgb9OHGifjS2dG03qLRqvXrDIRyfGAuc+GzF1z20/eVRV2wvl6tzgACNbzGCmSLCyXx8FUDAEIBvWNHOcE3QDUkDP/HB1kRbrIOoZ1dR874ZaGbMuvaSVHVWN2kfNiO4D+HlAzUEFaqlNi5FPqKw+mF8f0XwdpEBlClAQIDJiABIVgg0a6oo3W0JdYPu6+eBrbr0WyB3uJLI3ODVgDfQnpgafgiWCB4fFo/5iiVrFhB8pNH2tbBtKewyAHuDkRolcCnVaCcmQ==", value = "Base64-encoded attestation from the WebAuthn authenticator")
    @JsonProperty(JSON_PROPERTY_ATTESTATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAttestation() {
        return attestation;
    }

    @JsonProperty(JSON_PROPERTY_ATTESTATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAttestation(String attestation) {
        this.attestation = attestation;
    }

    public UserFactorActivateRequest clientData(String clientData) {

        this.clientData = clientData;
        return this;
    }

    /**
     * Base64-encoded client data from the WebAuthn authenticator
     *
     * @return clientData
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "eyJjaGFsbGVuZ2UiOiJVSk5wYW9sVWt0dF9vcEZPNXJMYyIsIm9yaWdpbiI6Imh0dHBzOi8vcmFpbi5va3RhMS5jb20iLCJ0eXBlIjoid2ViYXV0aG4uY3JlYXRlIn0", value = "Base64-encoded client data from the WebAuthn authenticator")
    @JsonProperty(JSON_PROPERTY_CLIENT_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientData() {
        return clientData;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorActivateRequest userFactorActivateRequest = (UserFactorActivateRequest) o;
        return Objects.equals(this.passCode, userFactorActivateRequest.passCode)
                && Objects.equals(this.registrationData, userFactorActivateRequest.registrationData)
                && Objects.equals(this.attestation, userFactorActivateRequest.attestation)
                && Objects.equals(this.clientData, userFactorActivateRequest.clientData);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(passCode, registrationData, attestation, clientData);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorActivateRequest {\n");
        sb.append("    passCode: ").append(toIndentedString(passCode)).append("\n");
        sb.append("    registrationData: ").append(toIndentedString(registrationData)).append("\n");
        sb.append("    attestation: ").append(toIndentedString(attestation)).append("\n");
        sb.append("    clientData: ").append(toIndentedString(clientData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
