package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The scope type. Supported values: When you use &#x60;IFRAME_EMBED&#x60; as the scope type, leave the allowedOktaApps
 * property empty to allow iFrame embedding of only Okta sign-in pages. Include &#x60;OKTA_ENDUSER&#x60; as a value for
 * the allowedOktaApps property to allow iFrame embedding of both Okta sign-in pages and the Okta End-User Dashboard.
 */
public enum TrustedOriginScopeType {

    CORS("CORS"),

    IFRAME_EMBED("IFRAME_EMBED"),

    REDIRECT("REDIRECT"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TrustedOriginScopeType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static TrustedOriginScopeType fromValue(String value) {
        for (TrustedOriginScopeType b : TrustedOriginScopeType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
