package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IframeEmbedScopeAllowedApps;
import com.okta.sdk.resource.model.TrustedOriginScopeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TrustedOriginScope
 */
@JsonPropertyOrder({ TrustedOriginScope.JSON_PROPERTY_ALLOWED_OKTA_APPS, TrustedOriginScope.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TrustedOriginScope implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALLOWED_OKTA_APPS = "allowedOktaApps";
    private List<IframeEmbedScopeAllowedApps> allowedOktaApps = null;

    public static final String JSON_PROPERTY_TYPE = "type";
    private TrustedOriginScopeType type;

    public TrustedOriginScope() {
    }

    public TrustedOriginScope allowedOktaApps(List<IframeEmbedScopeAllowedApps> allowedOktaApps) {

        this.allowedOktaApps = allowedOktaApps;
        return this;
    }

    public TrustedOriginScope addallowedOktaAppsItem(IframeEmbedScopeAllowedApps allowedOktaAppsItem) {
        if (this.allowedOktaApps == null) {
            this.allowedOktaApps = new ArrayList<>();
        }
        this.allowedOktaApps.add(allowedOktaAppsItem);
        return this;
    }

    /**
     * The allowed Okta apps for the Trusted Origin scope
     *
     * @return allowedOktaApps
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The allowed Okta apps for the Trusted Origin scope")
    @JsonProperty(JSON_PROPERTY_ALLOWED_OKTA_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<IframeEmbedScopeAllowedApps> getAllowedOktaApps() {
        return allowedOktaApps;
    }

    @JsonProperty(JSON_PROPERTY_ALLOWED_OKTA_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedOktaApps(List<IframeEmbedScopeAllowedApps> allowedOktaApps) {
        this.allowedOktaApps = allowedOktaApps;
    }

    public TrustedOriginScope type(TrustedOriginScopeType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TrustedOriginScopeType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TrustedOriginScopeType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrustedOriginScope trustedOriginScope = (TrustedOriginScope) o;
        return Objects.equals(this.allowedOktaApps, trustedOriginScope.allowedOktaApps)
                && Objects.equals(this.type, trustedOriginScope.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowedOktaApps, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustedOriginScope {\n");
        sb.append("    allowedOktaApps: ").append(toIndentedString(allowedOktaApps)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
