package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.NotificationType;
import com.okta.sdk.resource.model.SubscriptionLinks;
import com.okta.sdk.resource.model.SubscriptionStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Subscription
 */
@JsonPropertyOrder({ Subscription.JSON_PROPERTY_CHANNELS, Subscription.JSON_PROPERTY_NOTIFICATION_TYPE,
        Subscription.JSON_PROPERTY_STATUS, Subscription.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Subscription implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CHANNELS = "channels";
    private List<String> channels = null;

    public static final String JSON_PROPERTY_NOTIFICATION_TYPE = "notificationType";
    private NotificationType notificationType;

    public static final String JSON_PROPERTY_STATUS = "status";
    private SubscriptionStatus status;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private SubscriptionLinks links;

    public Subscription() {
    }

    public Subscription channels(List<String> channels) {

        this.channels = channels;
        return this;
    }

    public Subscription addchannelsItem(String channelsItem) {
        if (this.channels == null) {
            this.channels = new ArrayList<>();
        }
        this.channels.add(channelsItem);
        return this;
    }

    /**
     * An array of sources send notifications to users. &gt; **Note**: Currently, Okta only allows &#x60;email&#x60;
     * channels.
     *
     * @return channels
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An array of sources send notifications to users. > **Note**: Currently, Okta only allows `email` channels.")
    @JsonProperty(JSON_PROPERTY_CHANNELS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getChannels() {
        return channels;
    }

    @JsonProperty(JSON_PROPERTY_CHANNELS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setChannels(List<String> channels) {
        this.channels = channels;
    }

    public Subscription notificationType(NotificationType notificationType) {

        this.notificationType = notificationType;
        return this;
    }

    /**
     * Get notificationType
     *
     * @return notificationType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NOTIFICATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public NotificationType getNotificationType() {
        return notificationType;
    }

    @JsonProperty(JSON_PROPERTY_NOTIFICATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public Subscription status(SubscriptionStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SubscriptionStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(SubscriptionStatus status) {
        this.status = status;
    }

    public Subscription links(SubscriptionLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SubscriptionLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(SubscriptionLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription) o;
        return Objects.equals(this.channels, subscription.channels)
                && Objects.equals(this.notificationType, subscription.notificationType)
                && Objects.equals(this.status, subscription.status) && Objects.equals(this.links, subscription.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(channels, notificationType, status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    channels: ").append(toIndentedString(channels)).append("\n");
        sb.append("    notificationType: ").append(toIndentedString(notificationType)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
