package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import com.okta.sdk.resource.model.SecurityEventsProviderSettingsResponse;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The Security Events Provider response
 */
@ApiModel(description = "The Security Events Provider response")
@JsonPropertyOrder({ SecurityEventsProviderResponse.JSON_PROPERTY_ID, SecurityEventsProviderResponse.JSON_PROPERTY_NAME,
        SecurityEventsProviderResponse.JSON_PROPERTY_SETTINGS, SecurityEventsProviderResponse.JSON_PROPERTY_STATUS,
        SecurityEventsProviderResponse.JSON_PROPERTY_TYPE, SecurityEventsProviderResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SecurityEventsProviderResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private SecurityEventsProviderSettingsResponse settings;

    /**
     * Indicates whether the Security Events Provider is active or not
     */
    public enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),

        INACTIVE(String.valueOf("INACTIVE")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelfAndLifecycle links;

    public SecurityEventsProviderResponse() {
    }

    /*
     * @JsonCreator public SecurityEventsProviderResponse(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_STATUS) StatusEnum status ) { this(); this.id = id; this.status = status; }
     */

    /**
     * The unique identifier of this instance
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "sse1qg25RpusjUP6m0g5", value = "The unique identifier of this instance")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public SecurityEventsProviderResponse name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name of the Security Events Provider instance
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Target SSF Provider", value = "The name of the Security Events Provider instance")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SecurityEventsProviderResponse settings(SecurityEventsProviderSettingsResponse settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SecurityEventsProviderSettingsResponse getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(SecurityEventsProviderSettingsResponse settings) {
        this.settings = settings;
    }

    /**
     * Indicates whether the Security Events Provider is active or not
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the Security Events Provider is active or not")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    public SecurityEventsProviderResponse type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The application type of the Security Events Provider
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "okta", value = "The application type of the Security Events Provider")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public SecurityEventsProviderResponse links(LinksSelfAndLifecycle links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelfAndLifecycle getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelfAndLifecycle links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderResponse securityEventsProviderResponse = (SecurityEventsProviderResponse) o;
        return Objects.equals(this.id, securityEventsProviderResponse.id)
                && Objects.equals(this.name, securityEventsProviderResponse.name)
                && Objects.equals(this.settings, securityEventsProviderResponse.settings)
                && Objects.equals(this.status, securityEventsProviderResponse.status)
                && Objects.equals(this.type, securityEventsProviderResponse.type)
                && Objects.equals(this.links, securityEventsProviderResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, settings, status, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderResponse {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
