package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationCredentialsScheme;
import com.okta.sdk.resource.model.ApplicationCredentialsSigning;
import com.okta.sdk.resource.model.ApplicationCredentialsUsernameTemplate;
import com.okta.sdk.resource.model.PasswordCredential;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SchemeApplicationCredentials
 */
@JsonPropertyOrder({ SchemeApplicationCredentials.JSON_PROPERTY_SIGNING,
        SchemeApplicationCredentials.JSON_PROPERTY_USER_NAME_TEMPLATE,
        SchemeApplicationCredentials.JSON_PROPERTY_PASSWORD, SchemeApplicationCredentials.JSON_PROPERTY_REVEAL_PASSWORD,
        SchemeApplicationCredentials.JSON_PROPERTY_SCHEME, SchemeApplicationCredentials.JSON_PROPERTY_USER_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SchemeApplicationCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGNING = "signing";
    private ApplicationCredentialsSigning signing;

    public static final String JSON_PROPERTY_USER_NAME_TEMPLATE = "userNameTemplate";
    private ApplicationCredentialsUsernameTemplate userNameTemplate;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private PasswordCredential password;

    public static final String JSON_PROPERTY_REVEAL_PASSWORD = "revealPassword";
    private Boolean revealPassword;

    public static final String JSON_PROPERTY_SCHEME = "scheme";
    private ApplicationCredentialsScheme scheme;

    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public SchemeApplicationCredentials() {
    }

    public SchemeApplicationCredentials signing(ApplicationCredentialsSigning signing) {

        this.signing = signing;
        return this;
    }

    /**
     * Get signing
     *
     * @return signing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsSigning getSigning() {
        return signing;
    }

    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSigning(ApplicationCredentialsSigning signing) {
        this.signing = signing;
    }

    public SchemeApplicationCredentials userNameTemplate(ApplicationCredentialsUsernameTemplate userNameTemplate) {

        this.userNameTemplate = userNameTemplate;
        return this;
    }

    /**
     * Get userNameTemplate
     *
     * @return userNameTemplate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsUsernameTemplate getUserNameTemplate() {
        return userNameTemplate;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameTemplate(ApplicationCredentialsUsernameTemplate userNameTemplate) {
        this.userNameTemplate = userNameTemplate;
    }

    public SchemeApplicationCredentials password(PasswordCredential password) {

        this.password = password;
        return this;
    }

    /**
     * Get password
     *
     * @return password
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordCredential getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(PasswordCredential password) {
        this.password = password;
    }

    public SchemeApplicationCredentials revealPassword(Boolean revealPassword) {

        this.revealPassword = revealPassword;
        return this;
    }

    /**
     * Allow users to securely see their password
     *
     * @return revealPassword
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Allow users to securely see their password")
    @JsonProperty(JSON_PROPERTY_REVEAL_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRevealPassword() {
        return revealPassword;
    }

    @JsonProperty(JSON_PROPERTY_REVEAL_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRevealPassword(Boolean revealPassword) {
        this.revealPassword = revealPassword;
    }

    public SchemeApplicationCredentials scheme(ApplicationCredentialsScheme scheme) {

        this.scheme = scheme;
        return this;
    }

    /**
     * Get scheme
     *
     * @return scheme
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCHEME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsScheme getScheme() {
        return scheme;
    }

    @JsonProperty(JSON_PROPERTY_SCHEME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScheme(ApplicationCredentialsScheme scheme) {
        this.scheme = scheme;
    }

    public SchemeApplicationCredentials userName(String userName) {

        this.userName = userName;
        return this;
    }

    /**
     * Shared username for the app
     *
     * @return userName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Shared username for the app")
    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserName() {
        return userName;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchemeApplicationCredentials schemeApplicationCredentials = (SchemeApplicationCredentials) o;
        return Objects.equals(this.signing, schemeApplicationCredentials.signing)
                && Objects.equals(this.userNameTemplate, schemeApplicationCredentials.userNameTemplate)
                && Objects.equals(this.password, schemeApplicationCredentials.password)
                && Objects.equals(this.revealPassword, schemeApplicationCredentials.revealPassword)
                && Objects.equals(this.scheme, schemeApplicationCredentials.scheme)
                && Objects.equals(this.userName, schemeApplicationCredentials.userName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signing, userNameTemplate, password, revealPassword, scheme, userName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemeApplicationCredentials {\n");
        sb.append("    signing: ").append(toIndentedString(signing)).append("\n");
        sb.append("    userNameTemplate: ").append(toIndentedString(userNameTemplate)).append("\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    revealPassword: ").append(toIndentedString(revealPassword)).append("\n");
        sb.append("    scheme: ").append(toIndentedString(scheme)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
