package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.JsonWebKeyStatus;
import com.okta.sdk.resource.model.JsonWebKeyType;
import com.okta.sdk.resource.model.JsonWebKeyUse;
import com.okta.sdk.resource.model.SigningAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A [JSON Web Key (JWK)](https://tools.ietf.org/html/rfc7517) is a JSON representation of a cryptographic key. Okta can
 * use these keys to verify the signature of a JWT when provided for the &#x60;private_key_jwt&#x60; client
 * authentication method or for a signed authorize request object. Okta supports both RSA and Elliptic Curve (EC) keys.
 */
@ApiModel(description = "A [JSON Web Key (JWK)](https://tools.ietf.org/html/rfc7517) is a JSON representation of a cryptographic key. Okta can use these keys to verify the signature of a JWT when provided for the `private_key_jwt` client authentication method or for a signed authorize request object. Okta supports both RSA and Elliptic Curve (EC) keys.")
@JsonPropertyOrder({ SchemasJsonWebKey.JSON_PROPERTY_ALG, SchemasJsonWebKey.JSON_PROPERTY_KID,
        SchemasJsonWebKey.JSON_PROPERTY_KTY, SchemasJsonWebKey.JSON_PROPERTY_STATUS,
        SchemasJsonWebKey.JSON_PROPERTY_USE })
@JsonTypeName("schemas-JsonWebKey")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "kty", visible = true, defaultImpl = SchemasJsonWebKey.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = JsonWebKeyEC.class, name = "EC"),
        @JsonSubTypes.Type(value = JsonWebKeyRsa.class, name = "RSA"), })

public class SchemasJsonWebKey implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALG = "alg";
    private SigningAlgorithm alg;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_KTY = "kty";
    protected JsonWebKeyType kty;

    public static final String JSON_PROPERTY_STATUS = "status";
    private JsonWebKeyStatus status;

    public static final String JSON_PROPERTY_USE = "use";
    private JsonWebKeyUse use;

    public SchemasJsonWebKey() {
    }

    public SchemasJsonWebKey alg(SigningAlgorithm alg) {

        this.alg = alg;
        return this;
    }

    /**
     * Get alg
     *
     * @return alg
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SigningAlgorithm getAlg() {
        return alg;
    }

    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(SigningAlgorithm alg) {
        this.alg = alg;
    }

    public SchemasJsonWebKey kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * The unique identifier of the key
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier of the key")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public SchemasJsonWebKey kty(JsonWebKeyType kty) {

        this.kty = kty;
        return this;
    }

    /**
     * Get kty
     *
     * @return kty
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonWebKeyType getKty() {
        return kty;
    }

    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKty(JsonWebKeyType kty) {
        this.kty = kty;
    }

    public SchemasJsonWebKey status(JsonWebKeyStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonWebKeyStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(JsonWebKeyStatus status) {
        this.status = status;
    }

    public SchemasJsonWebKey use(JsonWebKeyUse use) {

        this.use = use;
        return this;
    }

    /**
     * Get use
     *
     * @return use
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonWebKeyUse getUse() {
        return use;
    }

    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUse(JsonWebKeyUse use) {
        this.use = use;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchemasJsonWebKey schemasJsonWebKey = (SchemasJsonWebKey) o;
        return Objects.equals(this.alg, schemasJsonWebKey.alg) && Objects.equals(this.kid, schemasJsonWebKey.kid)
                && Objects.equals(this.kty, schemasJsonWebKey.kty)
                && Objects.equals(this.status, schemasJsonWebKey.status)
                && Objects.equals(this.use, schemasJsonWebKey.use);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(alg, kid, kty, status, use);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemasJsonWebKey {\n");
        sb.append("    alg: ").append(toIndentedString(alg)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    kty: ").append(toIndentedString(kty)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    use: ").append(toIndentedString(use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
