package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdP&#39;s &#x60;SingleSignOnService&#x60; endpoint where Okta sends an &#x60;&lt;AuthnRequest&gt;&#x60; message
 */
@ApiModel(description = "IdP's `SingleSignOnService` endpoint where Okta sends an `<AuthnRequest>` message")
@JsonPropertyOrder({ SamlSsoEndpoint.JSON_PROPERTY_BINDING, SamlSsoEndpoint.JSON_PROPERTY_DESTINATION,
        SamlSsoEndpoint.JSON_PROPERTY_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SamlSsoEndpoint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;

    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private String destination;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public SamlSsoEndpoint() {
    }

    public SamlSsoEndpoint binding(ProtocolEndpointBinding binding) {

        this.binding = binding;
        return this;
    }

    /**
     * Get binding
     *
     * @return binding
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpointBinding getBinding() {
        return binding;
    }

    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public SamlSsoEndpoint destination(String destination) {

        this.destination = destination;
        return this;
    }

    /**
     * URI reference that indicates the address to which the &#x60;&lt;AuthnRequest&gt;&#x60; message is sent. The
     * &#x60;destination&#x60; property is required if request signatures are specified. See [SAML 2.0 Request Algorithm
     * object](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path&#x3D;protocol/0/algorithms/request&amp;t&#x3D;request).
     *
     * @return destination
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://idp.example.com/saml2/sso", value = "URI reference that indicates the address to which the `<AuthnRequest>` message is sent. The `destination` property is required if request signatures are specified. See [SAML 2.0 Request Algorithm object](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=protocol/0/algorithms/request&t=request).")
    @JsonProperty(JSON_PROPERTY_DESTINATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDestination() {
        return destination;
    }

    @JsonProperty(JSON_PROPERTY_DESTINATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public SamlSsoEndpoint url(String url) {

        this.url = url;
        return this;
    }

    /**
     * URL of the binding-specific endpoint to send an &#x60;&lt;AuthnRequest&gt;&#x60; message to the IdP. The value of
     * &#x60;url&#x60; defaults to the same value as the &#x60;sso&#x60; endpoint if omitted during creation of a new
     * IdP instance. The &#x60;url&#x60; should be the same value as the &#x60;Location&#x60; attribute for a published
     * binding in the IdP&#39;s SAML Metadata &#x60;IDPSSODescriptor&#x60;.
     *
     * @return url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://idp.example.com/saml2/sso", value = "URL of the binding-specific endpoint to send an `<AuthnRequest>` message to the IdP. The value of `url` defaults to the same value as the `sso` endpoint if omitted during creation of a new IdP instance. The `url` should be the same value as the `Location` attribute for a published binding in the IdP's SAML Metadata `IDPSSODescriptor`.")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlSsoEndpoint samlSsoEndpoint = (SamlSsoEndpoint) o;
        return Objects.equals(this.binding, samlSsoEndpoint.binding)
                && Objects.equals(this.destination, samlSsoEndpoint.destination)
                && Objects.equals(this.url, samlSsoEndpoint.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(binding, destination, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSsoEndpoint {\n");
        sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
        sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
