package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import com.okta.sdk.resource.model.SamlEndpointType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Okta&#39;s &#x60;SPSSODescriptor&#x60; endpoint where the IdP sends a &#x60;&lt;SAMLResponse&gt;&#x60; message
 */
@ApiModel(description = "Okta's `SPSSODescriptor` endpoint where the IdP sends a `<SAMLResponse>` message")
@JsonPropertyOrder({ SamlAcsEndpoint.JSON_PROPERTY_BINDING, SamlAcsEndpoint.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SamlAcsEndpoint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;

    public static final String JSON_PROPERTY_TYPE = "type";
    private SamlEndpointType type = SamlEndpointType.INSTANCE;

    public SamlAcsEndpoint() {
    }

    public SamlAcsEndpoint binding(ProtocolEndpointBinding binding) {

        this.binding = binding;
        return this;
    }

    /**
     * Get binding
     *
     * @return binding
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpointBinding getBinding() {
        return binding;
    }

    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public SamlAcsEndpoint type(SamlEndpointType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlEndpointType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(SamlEndpointType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlAcsEndpoint samlAcsEndpoint = (SamlAcsEndpoint) o;
        return Objects.equals(this.binding, samlAcsEndpoint.binding) && Objects.equals(this.type, samlAcsEndpoint.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(binding, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlAcsEndpoint {\n");
        sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
