package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The resource of a grant
 */
@ApiModel(description = "The resource of a grant")
@JsonPropertyOrder({ RoleGovernanceResource.JSON_PROPERTY_LABEL, RoleGovernanceResource.JSON_PROPERTY_RESOURCE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleGovernanceResource implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_RESOURCE = "resource";
    private String resource;

    public RoleGovernanceResource() {
    }

    public RoleGovernanceResource label(String label) {

        this.label = label;
        return this;
    }

    /**
     * The resource name
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The resource name")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public RoleGovernanceResource resource(String resource) {

        this.resource = resource;
        return this;
    }

    /**
     * The resources id
     *
     * @return resource
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The resources id")
    @JsonProperty(JSON_PROPERTY_RESOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResource() {
        return resource;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleGovernanceResource roleGovernanceResource = (RoleGovernanceResource) o;
        return Objects.equals(this.label, roleGovernanceResource.label)
                && Objects.equals(this.resource, roleGovernanceResource.resource);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(label, resource);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleGovernanceResource {\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
