package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RegistrationInlineHookSSRDataAllOfDataContext;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * RegistrationInlineHookSSRDataAllOfData
 */
@JsonPropertyOrder({ RegistrationInlineHookSSRDataAllOfData.JSON_PROPERTY_CONTEXT,
        RegistrationInlineHookSSRDataAllOfData.JSON_PROPERTY_ACTION,
        RegistrationInlineHookSSRDataAllOfData.JSON_PROPERTY_USER_PROFILE })
@JsonTypeName("RegistrationInlineHookSSRData_allOf_data")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RegistrationInlineHookSSRDataAllOfData implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONTEXT = "context";
    private RegistrationInlineHookSSRDataAllOfDataContext context;

    public static final String JSON_PROPERTY_ACTION = "action";
    private String action;

    public static final String JSON_PROPERTY_USER_PROFILE = "userProfile";
    private Map<String, Object> userProfile = null;

    public RegistrationInlineHookSSRDataAllOfData() {
    }

    public RegistrationInlineHookSSRDataAllOfData context(RegistrationInlineHookSSRDataAllOfDataContext context) {

        this.context = context;
        return this;
    }

    /**
     * Get context
     *
     * @return context
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RegistrationInlineHookSSRDataAllOfDataContext getContext() {
        return context;
    }

    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContext(RegistrationInlineHookSSRDataAllOfDataContext context) {
        this.context = context;
    }

    public RegistrationInlineHookSSRDataAllOfData action(String action) {

        this.action = action;
        return this;
    }

    /**
     * The default action the system will take. Will be &#x60;ALLOW&#x60;. &#x60;DENY&#x60; will never be sent to your
     * external service.
     *
     * @return action
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The default action the system will take. Will be `ALLOW`. `DENY` will never be sent to your external service.")
    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAction() {
        return action;
    }

    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAction(String action) {
        this.action = action;
    }

    public RegistrationInlineHookSSRDataAllOfData userProfile(Map<String, Object> userProfile) {

        this.userProfile = userProfile;
        return this;
    }

    public RegistrationInlineHookSSRDataAllOfData putuserProfileItem(String key, Object userProfileItem) {
        if (this.userProfile == null) {
            this.userProfile = new HashMap<>();
        }
        this.userProfile.put(key, userProfileItem);
        return this;
    }

    /**
     * The name-value pairs for each registration-related attribute supplied by the user in the Profile Enrollment form.
     *
     * @return userProfile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name-value pairs for each registration-related attribute supplied by the user in the Profile Enrollment form.")
    @JsonProperty(JSON_PROPERTY_USER_PROFILE)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getUserProfile() {
        return userProfile;
    }

    @JsonProperty(JSON_PROPERTY_USER_PROFILE)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserProfile(Map<String, Object> userProfile) {
        this.userProfile = userProfile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegistrationInlineHookSSRDataAllOfData registrationInlineHookSSRDataAllOfData = (RegistrationInlineHookSSRDataAllOfData) o;
        return Objects.equals(this.context, registrationInlineHookSSRDataAllOfData.context)
                && Objects.equals(this.action, registrationInlineHookSSRDataAllOfData.action)
                && Objects.equals(this.userProfile, registrationInlineHookSSRDataAllOfData.userProfile);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(context, action, userProfile);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationInlineHookSSRDataAllOfData {\n");
        sb.append("    context: ").append(toIndentedString(context)).append("\n");
        sb.append("    action: ").append(toIndentedString(action)).append("\n");
        sb.append("    userProfile: ").append(toIndentedString(userProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
