package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Credentials for the privileged account
 */
@ApiModel(description = "Credentials for the privileged account")
@JsonPropertyOrder({ PrivilegedResourceCredentials.JSON_PROPERTY_PASSWORD,
        PrivilegedResourceCredentials.JSON_PROPERTY_USER_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PrivilegedResourceCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;

    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public PrivilegedResourceCredentials() {
    }

    public PrivilegedResourceCredentials password(String password) {

        this.password = password;
        return this;
    }

    /**
     * The password associated with the privileged resource
     *
     * @return password
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "xf1bs9am2", value = "The password associated with the privileged resource")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public PrivilegedResourceCredentials userName(String userName) {

        this.userName = userName;
        return this;
    }

    /**
     * The username associated with the privileged resource
     *
     * @return userName
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "testuser@example.com", required = true, value = "The username associated with the privileged resource")
    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUserName() {
        return userName;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResourceCredentials privilegedResourceCredentials = (PrivilegedResourceCredentials) o;
        return Objects.equals(this.password, privilegedResourceCredentials.password)
                && Objects.equals(this.userName, privilegedResourceCredentials.userName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(password, userName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResourceCredentials {\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
