package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PolicyContextDevice
 */
@JsonPropertyOrder({ PolicyContextDevice.JSON_PROPERTY_PLATFORM, PolicyContextDevice.JSON_PROPERTY_REGISTERED,
        PolicyContextDevice.JSON_PROPERTY_MANAGED, PolicyContextDevice.JSON_PROPERTY_ASSURANCE_ID })
@JsonTypeName("PolicyContext_device")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PolicyContextDevice implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private String platform;

    public static final String JSON_PROPERTY_REGISTERED = "registered";
    private Boolean registered;

    public static final String JSON_PROPERTY_MANAGED = "managed";
    private Boolean managed;

    public static final String JSON_PROPERTY_ASSURANCE_ID = "assuranceId";
    private String assuranceId;

    public PolicyContextDevice() {
    }

    public PolicyContextDevice platform(String platform) {

        this.platform = platform;
        return this;
    }

    /**
     * The platform of the device, for example, IOS.
     *
     * @return platform
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The platform of the device, for example, IOS.")
    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPlatform() {
        return platform;
    }

    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public PolicyContextDevice registered(Boolean registered) {

        this.registered = registered;
        return this;
    }

    /**
     * If the device is registered
     *
     * @return registered
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If the device is registered")
    @JsonProperty(JSON_PROPERTY_REGISTERED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRegistered() {
        return registered;
    }

    @JsonProperty(JSON_PROPERTY_REGISTERED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRegistered(Boolean registered) {
        this.registered = registered;
    }

    public PolicyContextDevice managed(Boolean managed) {

        this.managed = managed;
        return this;
    }

    /**
     * If the device is managed
     *
     * @return managed
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If the device is managed")
    @JsonProperty(JSON_PROPERTY_MANAGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getManaged() {
        return managed;
    }

    @JsonProperty(JSON_PROPERTY_MANAGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    public PolicyContextDevice assuranceId(String assuranceId) {

        this.assuranceId = assuranceId;
        return this;
    }

    /**
     * The device assurance policy ID for the simulation
     *
     * @return assuranceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The device assurance policy ID for the simulation")
    @JsonProperty(JSON_PROPERTY_ASSURANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAssuranceId() {
        return assuranceId;
    }

    @JsonProperty(JSON_PROPERTY_ASSURANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssuranceId(String assuranceId) {
        this.assuranceId = assuranceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PolicyContextDevice policyContextDevice = (PolicyContextDevice) o;
        return Objects.equals(this.platform, policyContextDevice.platform)
                && Objects.equals(this.registered, policyContextDevice.registered)
                && Objects.equals(this.managed, policyContextDevice.managed)
                && Objects.equals(this.assuranceId, policyContextDevice.assuranceId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(platform, registered, managed, assuranceId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyContextDevice {\n");
        sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
        sb.append("    registered: ").append(toIndentedString(registered)).append("\n");
        sb.append("    managed: ").append(toIndentedString(managed)).append("\n");
        sb.append("    assuranceId: ").append(toIndentedString(assuranceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
