package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Lockout settings
 */
@ApiModel(description = "Lockout settings")
@JsonPropertyOrder({ PasswordPolicyPasswordSettingsLockout.JSON_PROPERTY_AUTO_UNLOCK_MINUTES,
        PasswordPolicyPasswordSettingsLockout.JSON_PROPERTY_MAX_ATTEMPTS,
        PasswordPolicyPasswordSettingsLockout.JSON_PROPERTY_SHOW_LOCKOUT_FAILURES,
        PasswordPolicyPasswordSettingsLockout.JSON_PROPERTY_USER_LOCKOUT_NOTIFICATION_CHANNELS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordPolicyPasswordSettingsLockout implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTO_UNLOCK_MINUTES = "autoUnlockMinutes";
    private Integer autoUnlockMinutes = 0;

    public static final String JSON_PROPERTY_MAX_ATTEMPTS = "maxAttempts";
    private Integer maxAttempts = 10;

    public static final String JSON_PROPERTY_SHOW_LOCKOUT_FAILURES = "showLockoutFailures";
    private Boolean showLockoutFailures = false;

    public static final String JSON_PROPERTY_USER_LOCKOUT_NOTIFICATION_CHANNELS = "userLockoutNotificationChannels";
    private List<String> userLockoutNotificationChannels = null;

    public PasswordPolicyPasswordSettingsLockout() {
    }

    public PasswordPolicyPasswordSettingsLockout autoUnlockMinutes(Integer autoUnlockMinutes) {

        this.autoUnlockMinutes = autoUnlockMinutes;
        return this;
    }

    /**
     * Specifies the time interval (in minutes) a locked account remains locked before it is automatically unlocked:
     * &#x60;0&#x60; indicates no limit
     *
     * @return autoUnlockMinutes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the time interval (in minutes) a locked account remains locked before it is automatically unlocked: `0` indicates no limit")
    @JsonProperty(JSON_PROPERTY_AUTO_UNLOCK_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getAutoUnlockMinutes() {
        return autoUnlockMinutes;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_UNLOCK_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoUnlockMinutes(Integer autoUnlockMinutes) {
        this.autoUnlockMinutes = autoUnlockMinutes;
    }

    public PasswordPolicyPasswordSettingsLockout maxAttempts(Integer maxAttempts) {

        this.maxAttempts = maxAttempts;
        return this;
    }

    /**
     * Specifies the number of times Users can attempt to sign in to their accounts with an invalid password before
     * their accounts are locked: &#x60;0&#x60; indicates no limit
     *
     * @return maxAttempts
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the number of times Users can attempt to sign in to their accounts with an invalid password before their accounts are locked: `0` indicates no limit")
    @JsonProperty(JSON_PROPERTY_MAX_ATTEMPTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMaxAttempts() {
        return maxAttempts;
    }

    @JsonProperty(JSON_PROPERTY_MAX_ATTEMPTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public PasswordPolicyPasswordSettingsLockout showLockoutFailures(Boolean showLockoutFailures) {

        this.showLockoutFailures = showLockoutFailures;
        return this;
    }

    /**
     * Indicates if the User should be informed when their account is locked
     *
     * @return showLockoutFailures
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the User should be informed when their account is locked")
    @JsonProperty(JSON_PROPERTY_SHOW_LOCKOUT_FAILURES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getShowLockoutFailures() {
        return showLockoutFailures;
    }

    @JsonProperty(JSON_PROPERTY_SHOW_LOCKOUT_FAILURES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setShowLockoutFailures(Boolean showLockoutFailures) {
        this.showLockoutFailures = showLockoutFailures;
    }

    public PasswordPolicyPasswordSettingsLockout userLockoutNotificationChannels(
            List<String> userLockoutNotificationChannels) {

        this.userLockoutNotificationChannels = userLockoutNotificationChannels;
        return this;
    }

    public PasswordPolicyPasswordSettingsLockout adduserLockoutNotificationChannelsItem(
            String userLockoutNotificationChannelsItem) {
        if (this.userLockoutNotificationChannels == null) {
            this.userLockoutNotificationChannels = new ArrayList<>();
        }
        this.userLockoutNotificationChannels.add(userLockoutNotificationChannelsItem);
        return this;
    }

    /**
     * How the user is notified when their account becomes locked. The only acceptable values are &#x60;[]&#x60; and
     * &#x60;[&#39;EMAIL&#39;]&#x60;.
     *
     * @return userLockoutNotificationChannels
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "How the user is notified when their account becomes locked. The only acceptable values are `[]` and `['EMAIL']`.")
    @JsonProperty(JSON_PROPERTY_USER_LOCKOUT_NOTIFICATION_CHANNELS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getUserLockoutNotificationChannels() {
        return userLockoutNotificationChannels;
    }

    @JsonProperty(JSON_PROPERTY_USER_LOCKOUT_NOTIFICATION_CHANNELS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserLockoutNotificationChannels(List<String> userLockoutNotificationChannels) {
        this.userLockoutNotificationChannels = userLockoutNotificationChannels;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyPasswordSettingsLockout passwordPolicyPasswordSettingsLockout = (PasswordPolicyPasswordSettingsLockout) o;
        return Objects.equals(this.autoUnlockMinutes, passwordPolicyPasswordSettingsLockout.autoUnlockMinutes)
                && Objects.equals(this.maxAttempts, passwordPolicyPasswordSettingsLockout.maxAttempts)
                && Objects.equals(this.showLockoutFailures, passwordPolicyPasswordSettingsLockout.showLockoutFailures)
                && Objects.equals(this.userLockoutNotificationChannels,
                        passwordPolicyPasswordSettingsLockout.userLockoutNotificationChannels);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(autoUnlockMinutes, maxAttempts, showLockoutFailures, userLockoutNotificationChannels);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicyPasswordSettingsLockout {\n");
        sb.append("    autoUnlockMinutes: ").append(toIndentedString(autoUnlockMinutes)).append("\n");
        sb.append("    maxAttempts: ").append(toIndentedString(maxAttempts)).append("\n");
        sb.append("    showLockoutFailures: ").append(toIndentedString(showLockoutFailures)).append("\n");
        sb.append("    userLockoutNotificationChannels: ").append(toIndentedString(userLockoutNotificationChannels))
                .append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
