package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgOktaSupportSettingsObjLinksExtend;
import com.okta.sdk.resource.model.OrgOktaSupportSettingsObjLinksGrant;
import com.okta.sdk.resource.model.OrgOktaSupportSettingsObjLinksRevoke;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the Okta Support
 * Settings object using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the Okta Support Settings object using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ OrgOktaSupportSettingsObjLinks.JSON_PROPERTY_EXTEND,
        OrgOktaSupportSettingsObjLinks.JSON_PROPERTY_REVOKE, OrgOktaSupportSettingsObjLinks.JSON_PROPERTY_GRANT })
@JsonTypeName("OrgOktaSupportSettingsObj__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgOktaSupportSettingsObjLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXTEND = "extend";
    private OrgOktaSupportSettingsObjLinksExtend extend;

    public static final String JSON_PROPERTY_REVOKE = "revoke";
    private OrgOktaSupportSettingsObjLinksRevoke revoke;

    public static final String JSON_PROPERTY_GRANT = "grant";
    private OrgOktaSupportSettingsObjLinksGrant grant;

    public OrgOktaSupportSettingsObjLinks() {
    }

    public OrgOktaSupportSettingsObjLinks extend(OrgOktaSupportSettingsObjLinksExtend extend) {

        this.extend = extend;
        return this;
    }

    /**
     * Get extend
     *
     * @return extend
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EXTEND)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaSupportSettingsObjLinksExtend getExtend() {
        return extend;
    }

    @JsonProperty(JSON_PROPERTY_EXTEND)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExtend(OrgOktaSupportSettingsObjLinksExtend extend) {
        this.extend = extend;
    }

    public OrgOktaSupportSettingsObjLinks revoke(OrgOktaSupportSettingsObjLinksRevoke revoke) {

        this.revoke = revoke;
        return this;
    }

    /**
     * Get revoke
     *
     * @return revoke
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REVOKE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaSupportSettingsObjLinksRevoke getRevoke() {
        return revoke;
    }

    @JsonProperty(JSON_PROPERTY_REVOKE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRevoke(OrgOktaSupportSettingsObjLinksRevoke revoke) {
        this.revoke = revoke;
    }

    public OrgOktaSupportSettingsObjLinks grant(OrgOktaSupportSettingsObjLinksGrant grant) {

        this.grant = grant;
        return this;
    }

    /**
     * Get grant
     *
     * @return grant
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GRANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaSupportSettingsObjLinksGrant getGrant() {
        return grant;
    }

    @JsonProperty(JSON_PROPERTY_GRANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrant(OrgOktaSupportSettingsObjLinksGrant grant) {
        this.grant = grant;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgOktaSupportSettingsObjLinks orgOktaSupportSettingsObjLinks = (OrgOktaSupportSettingsObjLinks) o;
        return Objects.equals(this.extend, orgOktaSupportSettingsObjLinks.extend)
                && Objects.equals(this.revoke, orgOktaSupportSettingsObjLinks.revoke)
                && Objects.equals(this.grant, orgOktaSupportSettingsObjLinks.grant);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(extend, revoke, grant);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgOktaSupportSettingsObjLinks {\n");
        sb.append("    extend: ").append(toIndentedString(extend)).append("\n");
        sb.append("    revoke: ").append(toIndentedString(revoke)).append("\n");
        sb.append("    grant: ").append(toIndentedString(grant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
