package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgGeneralSettingLinksContacts;
import com.okta.sdk.resource.model.OrgGeneralSettingLinksLogo;
import com.okta.sdk.resource.model.OrgGeneralSettingLinksOktaCommunication;
import com.okta.sdk.resource.model.OrgGeneralSettingLinksOktaSupport;
import com.okta.sdk.resource.model.OrgGeneralSettingLinksPreferences;
import com.okta.sdk.resource.model.OrgGeneralSettingLinksUploadLogo;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the org using the
 * [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the org using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ OrgGeneralSettingLinks.JSON_PROPERTY_CONTACTS, OrgGeneralSettingLinks.JSON_PROPERTY_LOGO,
        OrgGeneralSettingLinks.JSON_PROPERTY_OKTA_COMMUNICATION, OrgGeneralSettingLinks.JSON_PROPERTY_OKTA_SUPPORT,
        OrgGeneralSettingLinks.JSON_PROPERTY_PREFERENCES, OrgGeneralSettingLinks.JSON_PROPERTY_UPLOAD_LOGO })
@JsonTypeName("orgGeneralSettingLinks")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgGeneralSettingLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONTACTS = "contacts";
    private OrgGeneralSettingLinksContacts contacts;

    public static final String JSON_PROPERTY_LOGO = "logo";
    private OrgGeneralSettingLinksLogo logo;

    public static final String JSON_PROPERTY_OKTA_COMMUNICATION = "oktaCommunication";
    private OrgGeneralSettingLinksOktaCommunication oktaCommunication;

    public static final String JSON_PROPERTY_OKTA_SUPPORT = "oktaSupport";
    private OrgGeneralSettingLinksOktaSupport oktaSupport;

    public static final String JSON_PROPERTY_PREFERENCES = "preferences";
    private OrgGeneralSettingLinksPreferences preferences;

    public static final String JSON_PROPERTY_UPLOAD_LOGO = "uploadLogo";
    private OrgGeneralSettingLinksUploadLogo uploadLogo;

    public OrgGeneralSettingLinks() {
    }

    public OrgGeneralSettingLinks contacts(OrgGeneralSettingLinksContacts contacts) {

        this.contacts = contacts;
        return this;
    }

    /**
     * Get contacts
     *
     * @return contacts
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONTACTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgGeneralSettingLinksContacts getContacts() {
        return contacts;
    }

    @JsonProperty(JSON_PROPERTY_CONTACTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContacts(OrgGeneralSettingLinksContacts contacts) {
        this.contacts = contacts;
    }

    public OrgGeneralSettingLinks logo(OrgGeneralSettingLinksLogo logo) {

        this.logo = logo;
        return this;
    }

    /**
     * Get logo
     *
     * @return logo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgGeneralSettingLinksLogo getLogo() {
        return logo;
    }

    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(OrgGeneralSettingLinksLogo logo) {
        this.logo = logo;
    }

    public OrgGeneralSettingLinks oktaCommunication(OrgGeneralSettingLinksOktaCommunication oktaCommunication) {

        this.oktaCommunication = oktaCommunication;
        return this;
    }

    /**
     * Get oktaCommunication
     *
     * @return oktaCommunication
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OKTA_COMMUNICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgGeneralSettingLinksOktaCommunication getOktaCommunication() {
        return oktaCommunication;
    }

    @JsonProperty(JSON_PROPERTY_OKTA_COMMUNICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOktaCommunication(OrgGeneralSettingLinksOktaCommunication oktaCommunication) {
        this.oktaCommunication = oktaCommunication;
    }

    public OrgGeneralSettingLinks oktaSupport(OrgGeneralSettingLinksOktaSupport oktaSupport) {

        this.oktaSupport = oktaSupport;
        return this;
    }

    /**
     * Get oktaSupport
     *
     * @return oktaSupport
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OKTA_SUPPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgGeneralSettingLinksOktaSupport getOktaSupport() {
        return oktaSupport;
    }

    @JsonProperty(JSON_PROPERTY_OKTA_SUPPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOktaSupport(OrgGeneralSettingLinksOktaSupport oktaSupport) {
        this.oktaSupport = oktaSupport;
    }

    public OrgGeneralSettingLinks preferences(OrgGeneralSettingLinksPreferences preferences) {

        this.preferences = preferences;
        return this;
    }

    /**
     * Get preferences
     *
     * @return preferences
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PREFERENCES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgGeneralSettingLinksPreferences getPreferences() {
        return preferences;
    }

    @JsonProperty(JSON_PROPERTY_PREFERENCES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPreferences(OrgGeneralSettingLinksPreferences preferences) {
        this.preferences = preferences;
    }

    public OrgGeneralSettingLinks uploadLogo(OrgGeneralSettingLinksUploadLogo uploadLogo) {

        this.uploadLogo = uploadLogo;
        return this;
    }

    /**
     * Get uploadLogo
     *
     * @return uploadLogo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_UPLOAD_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgGeneralSettingLinksUploadLogo getUploadLogo() {
        return uploadLogo;
    }

    @JsonProperty(JSON_PROPERTY_UPLOAD_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUploadLogo(OrgGeneralSettingLinksUploadLogo uploadLogo) {
        this.uploadLogo = uploadLogo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgGeneralSettingLinks orgGeneralSettingLinks = (OrgGeneralSettingLinks) o;
        return Objects.equals(this.contacts, orgGeneralSettingLinks.contacts)
                && Objects.equals(this.logo, orgGeneralSettingLinks.logo)
                && Objects.equals(this.oktaCommunication, orgGeneralSettingLinks.oktaCommunication)
                && Objects.equals(this.oktaSupport, orgGeneralSettingLinks.oktaSupport)
                && Objects.equals(this.preferences, orgGeneralSettingLinks.preferences)
                && Objects.equals(this.uploadLogo, orgGeneralSettingLinks.uploadLogo);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(contacts, logo, oktaCommunication, oktaSupport, preferences, uploadLogo);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgGeneralSettingLinks {\n");
        sb.append("    contacts: ").append(toIndentedString(contacts)).append("\n");
        sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
        sb.append("    oktaCommunication: ").append(toIndentedString(oktaCommunication)).append("\n");
        sb.append("    oktaSupport: ").append(toIndentedString(oktaSupport)).append("\n");
        sb.append("    preferences: ").append(toIndentedString(preferences)).append("\n");
        sb.append("    uploadLogo: ").append(toIndentedString(uploadLogo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
