package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgBillingContactTypeLinksBilling;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the org billing
 * Contact Type object using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the org billing Contact Type object using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ OrgBillingContactTypeLinks.JSON_PROPERTY_BILLING })
@JsonTypeName("orgBillingContactType__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgBillingContactTypeLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BILLING = "billing";
    private OrgBillingContactTypeLinksBilling billing;

    public OrgBillingContactTypeLinks() {
    }

    public OrgBillingContactTypeLinks billing(OrgBillingContactTypeLinksBilling billing) {

        this.billing = billing;
        return this;
    }

    /**
     * Get billing
     *
     * @return billing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BILLING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgBillingContactTypeLinksBilling getBilling() {
        return billing;
    }

    @JsonProperty(JSON_PROPERTY_BILLING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBilling(OrgBillingContactTypeLinksBilling billing) {
        this.billing = billing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgBillingContactTypeLinks orgBillingContactTypeLinks = (OrgBillingContactTypeLinks) o;
        return Objects.equals(this.billing, orgBillingContactTypeLinks.billing);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(billing);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgBillingContactTypeLinks {\n");
        sb.append("    billing: ").append(toIndentedString(billing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
