package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthAuthorizationEndpoint;
import com.okta.sdk.resource.model.OAuthTokenEndpoint;
import com.okta.sdk.resource.model.OidcJwksEndpoint;
import com.okta.sdk.resource.model.OidcUserInfoEndpoint;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The &#x60;OAUTH2&#x60; and &#x60;OIDC&#x60; protocols support the &#x60;authorization&#x60; and &#x60;token&#x60;
 * endpoints. Also, the &#x60;OIDC&#x60; protocol supports the &#x60;userInfo&#x60; and &#x60;jwks&#x60; endpoints. The
 * IdP Authorization Server (AS) endpoints are currently defined as part of the [IdP
 * provider]((https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path&#x3D;type&amp;t&#x3D;request))
 * and are read-only.
 */
@ApiModel(description = "The `OAUTH2` and `OIDC` protocols support the `authorization` and `token` endpoints. Also, the `OIDC` protocol supports the `userInfo` and `jwks` endpoints.  The IdP Authorization Server (AS) endpoints are currently defined as part of the [IdP provider]((https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=type&t=request)) and are read-only.")
@JsonPropertyOrder({ OAuthEndpoints.JSON_PROPERTY_AUTHORIZATION, OAuthEndpoints.JSON_PROPERTY_JWKS,
        OAuthEndpoints.JSON_PROPERTY_TOKEN, OAuthEndpoints.JSON_PROPERTY_USER_INFO })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuthEndpoints implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHORIZATION = "authorization";
    private OAuthAuthorizationEndpoint authorization;

    public static final String JSON_PROPERTY_JWKS = "jwks";
    private OidcJwksEndpoint jwks;

    public static final String JSON_PROPERTY_TOKEN = "token";
    private OAuthTokenEndpoint token;

    public static final String JSON_PROPERTY_USER_INFO = "userInfo";
    private OidcUserInfoEndpoint userInfo;

    public OAuthEndpoints() {
    }

    public OAuthEndpoints authorization(OAuthAuthorizationEndpoint authorization) {

        this.authorization = authorization;
        return this;
    }

    /**
     * Get authorization
     *
     * @return authorization
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUTHORIZATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthAuthorizationEndpoint getAuthorization() {
        return authorization;
    }

    @JsonProperty(JSON_PROPERTY_AUTHORIZATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorization(OAuthAuthorizationEndpoint authorization) {
        this.authorization = authorization;
    }

    public OAuthEndpoints jwks(OidcJwksEndpoint jwks) {

        this.jwks = jwks;
        return this;
    }

    /**
     * Get jwks
     *
     * @return jwks
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_JWKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OidcJwksEndpoint getJwks() {
        return jwks;
    }

    @JsonProperty(JSON_PROPERTY_JWKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJwks(OidcJwksEndpoint jwks) {
        this.jwks = jwks;
    }

    public OAuthEndpoints token(OAuthTokenEndpoint token) {

        this.token = token;
        return this;
    }

    /**
     * Get token
     *
     * @return token
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthTokenEndpoint getToken() {
        return token;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setToken(OAuthTokenEndpoint token) {
        this.token = token;
    }

    public OAuthEndpoints userInfo(OidcUserInfoEndpoint userInfo) {

        this.userInfo = userInfo;
        return this;
    }

    /**
     * Get userInfo
     *
     * @return userInfo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_INFO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OidcUserInfoEndpoint getUserInfo() {
        return userInfo;
    }

    @JsonProperty(JSON_PROPERTY_USER_INFO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserInfo(OidcUserInfoEndpoint userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuthEndpoints oauthEndpoints = (OAuthEndpoints) o;
        return Objects.equals(this.authorization, oauthEndpoints.authorization)
                && Objects.equals(this.jwks, oauthEndpoints.jwks) && Objects.equals(this.token, oauthEndpoints.token)
                && Objects.equals(this.userInfo, oauthEndpoints.userInfo);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authorization, jwks, token, userInfo);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthEndpoints {\n");
        sb.append("    authorization: ").append(toIndentedString(authorization)).append("\n");
        sb.append("    jwks: ").append(toIndentedString(jwks)).append("\n");
        sb.append("    token: ").append(toIndentedString(token)).append("\n");
        sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
