package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SplunkEdition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the configuration for the &#x60;splunk_cloud_logstreaming&#x60; Log Stream type.
 */
@ApiModel(description = "Specifies the configuration for the `splunk_cloud_logstreaming` Log Stream type.")
@JsonPropertyOrder({ LogStreamSettingsSplunk.JSON_PROPERTY_EDITION, LogStreamSettingsSplunk.JSON_PROPERTY_HOST,
        LogStreamSettingsSplunk.JSON_PROPERTY_TOKEN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LogStreamSettingsSplunk implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EDITION = "edition";
    private SplunkEdition edition;

    public static final String JSON_PROPERTY_HOST = "host";
    private String host;

    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;

    public LogStreamSettingsSplunk() {
    }

    public LogStreamSettingsSplunk edition(SplunkEdition edition) {

        this.edition = edition;
        return this;
    }

    /**
     * Get edition
     *
     * @return edition
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_EDITION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SplunkEdition getEdition() {
        return edition;
    }

    @JsonProperty(JSON_PROPERTY_EDITION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEdition(SplunkEdition edition) {
        this.edition = edition;
    }

    public LogStreamSettingsSplunk host(String host) {

        this.host = host;
        return this;
    }

    /**
     * The domain name for your Splunk Cloud instance. Don&#39;t include &#x60;http&#x60; or &#x60;https&#x60; in the
     * string. For example: &#x60;acme.splunkcloud.com&#x60;
     *
     * @return host
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "acme.splunkcloud.com", required = true, value = "The domain name for your Splunk Cloud instance. Don't include `http` or `https` in the string. For example: `acme.splunkcloud.com`")
    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHost() {
        return host;
    }

    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHost(String host) {
        this.host = host;
    }

    public LogStreamSettingsSplunk token(String token) {

        this.token = token;
        return this;
    }

    /**
     * The HEC token for your Splunk Cloud HTTP Event Collector. The token value is set at object creation, but
     * isn&#39;t returned.
     *
     * @return token
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "11111111-1111-2222-2222-222222222222", required = true, value = "The HEC token for your Splunk Cloud HTTP Event Collector. The token value is set at object creation, but isn't returned.")
    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getToken() {
        return token;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogStreamSettingsSplunk logStreamSettingsSplunk = (LogStreamSettingsSplunk) o;
        return Objects.equals(this.edition, logStreamSettingsSplunk.edition)
                && Objects.equals(this.host, logStreamSettingsSplunk.host)
                && Objects.equals(this.token, logStreamSettingsSplunk.token);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(edition, host, token);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamSettingsSplunk {\n");
        sb.append("    edition: ").append(toIndentedString(edition)).append("\n");
        sb.append("    host: ").append(toIndentedString(host)).append("\n");
        sb.append("    token: ").append(toIndentedString(token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
