package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.UserSchemaAttributeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * LogStreamSchema
 */
@JsonPropertyOrder({ LogStreamSchema.JSON_PROPERTY_$_SCHEMA, LogStreamSchema.JSON_PROPERTY_ERROR_MESSAGE,
        LogStreamSchema.JSON_PROPERTY_ID, LogStreamSchema.JSON_PROPERTY_ONE_OF, LogStreamSchema.JSON_PROPERTY_PATTERN,
        LogStreamSchema.JSON_PROPERTY_PROPERTIES, LogStreamSchema.JSON_PROPERTY_REQUIRED,
        LogStreamSchema.JSON_PROPERTY_TITLE, LogStreamSchema.JSON_PROPERTY_TYPE, LogStreamSchema.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LogStreamSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_$_SCHEMA = "$schema";
    private String $schema;

    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private Object errorMessage;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_ONE_OF = "oneOf";
    private JsonNullable<List<UserSchemaAttributeEnum>> oneOf = JsonNullable
            .<List<UserSchemaAttributeEnum>> undefined();

    public static final String JSON_PROPERTY_PATTERN = "pattern";
    private String pattern;

    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Object properties;

    public static final String JSON_PROPERTY_REQUIRED = "required";
    private List<String> required = null;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public LogStreamSchema() {
    }

    /*
     * @JsonCreator public LogStreamSchema(
     *
     * @JsonProperty(JSON_PROPERTY_$_SCHEMA) String $schema,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.$schema = $schema; this.id = id; this.type = type;
     * }
     */

    /**
     * JSON Schema version identifier
     *
     * @return $schema
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "JSON Schema version identifier")
    @JsonProperty(JSON_PROPERTY_$_SCHEMA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String get$Schema() {
        return $schema;
    }

    public LogStreamSchema errorMessage(Object errorMessage) {

        this.errorMessage = errorMessage;
        return this;
    }

    /**
     * A collection of error messages for individual properties in the schema. Okta implements a subset of
     * [ajv-errors](https://github.com/ajv-validator/ajv-errors).
     *
     * @return errorMessage
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A collection of error messages for individual properties in the schema. Okta implements a subset of [ajv-errors](https://github.com/ajv-validator/ajv-errors).")
    @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getErrorMessage() {
        return errorMessage;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * URI of Log Stream Schema
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URI of Log Stream Schema")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public LogStreamSchema oneOf(List<UserSchemaAttributeEnum> oneOf) {
        this.oneOf = JsonNullable.<List<UserSchemaAttributeEnum>> of(oneOf);

        return this;
    }

    public LogStreamSchema addoneOfItem(UserSchemaAttributeEnum oneOfItem) {
        if (this.oneOf == null || !this.oneOf.isPresent()) {
            this.oneOf = JsonNullable.<List<UserSchemaAttributeEnum>> of(new ArrayList<>());
        }
        try {
            this.oneOf.get().add(oneOfItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * Non-empty array of valid JSON schemas. Okta only supports &#x60;oneOf&#x60; for specifying display names for an
     * &#x60;enum&#x60;. Each schema has the following format: &#x60;&#x60;&#x60; { \&quot;const\&quot;:
     * \&quot;enumValue\&quot;, \&quot;title\&quot;: \&quot;display name\&quot; } &#x60;&#x60;&#x60;json
     *
     * @return oneOf
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Non-empty array of valid JSON schemas.  Okta only supports `oneOf` for specifying display names for an `enum`. Each schema has the following format:    ```     {       \"const\": \"enumValue\",       \"title\": \"display name\"     }   ```json")
    @JsonIgnore

    public List<UserSchemaAttributeEnum> getOneOf() {
        return oneOf.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ONE_OF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<List<UserSchemaAttributeEnum>> getOneOf_JsonNullable() {
        return oneOf;
    }

    @JsonProperty(JSON_PROPERTY_ONE_OF)
    public void setOneOf_JsonNullable(JsonNullable<List<UserSchemaAttributeEnum>> oneOf) {
        this.oneOf = oneOf;
    }

    public void setOneOf(List<UserSchemaAttributeEnum> oneOf) {
        this.oneOf = JsonNullable.<List<UserSchemaAttributeEnum>> of(oneOf);
    }

    public LogStreamSchema pattern(String pattern) {

        this.pattern = pattern;
        return this;
    }

    /**
     * For &#x60;string&#x60; Log Stream Schema property type, specifies the regular expression used to validate the
     * property
     *
     * @return pattern
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "For `string` Log Stream Schema property type, specifies the regular expression used to validate the property")
    @JsonProperty(JSON_PROPERTY_PATTERN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPattern() {
        return pattern;
    }

    @JsonProperty(JSON_PROPERTY_PATTERN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public LogStreamSchema properties(Object properties) {

        this.properties = properties;
        return this;
    }

    /**
     * Log Stream Schema properties object
     *
     * @return properties
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Log Stream Schema properties object")
    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getProperties() {
        return properties;
    }

    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public LogStreamSchema required(List<String> required) {

        this.required = required;
        return this;
    }

    public LogStreamSchema addrequiredItem(String requiredItem) {
        if (this.required == null) {
            this.required = new ArrayList<>();
        }
        this.required.add(requiredItem);
        return this;
    }

    /**
     * Required properties for this Log Stream Schema object
     *
     * @return required
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Required properties for this Log Stream Schema object")
    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getRequired() {
        return required;
    }

    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(List<String> required) {
        this.required = required;
    }

    public LogStreamSchema title(String title) {

        this.title = title;
        return this;
    }

    /**
     * Name of the Log Streaming integration
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Log Streaming integration")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Type of Log Stream Schema property
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of Log Stream Schema property")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    public LogStreamSchema links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogStreamSchema logStreamSchema = (LogStreamSchema) o;
        return Objects.equals(this.$schema, logStreamSchema.$schema)
                && Objects.equals(this.errorMessage, logStreamSchema.errorMessage)
                && Objects.equals(this.id, logStreamSchema.id) && equalsNullable(this.oneOf, logStreamSchema.oneOf)
                && Objects.equals(this.pattern, logStreamSchema.pattern)
                && Objects.equals(this.properties, logStreamSchema.properties)
                && Objects.equals(this.required, logStreamSchema.required)
                && Objects.equals(this.title, logStreamSchema.title) && Objects.equals(this.type, logStreamSchema.type)
                && Objects.equals(this.links, logStreamSchema.links);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash($schema, errorMessage, id, hashCodeNullable(oneOf), pattern, properties, required, title,
                type, links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamSchema {\n");
        sb.append("    $schema: ").append(toIndentedString($schema)).append("\n");
        sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    oneOf: ").append(toIndentedString(oneOf)).append("\n");
        sb.append("    pattern: ").append(toIndentedString(pattern)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    required: ").append(toIndentedString(required)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
