package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdpPolicyRuleActionMatchCriteria;
import com.okta.sdk.resource.model.IdpPolicyRuleActionProvider;
import com.okta.sdk.resource.model.IdpSelectionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdpPolicyRuleActionIdp
 */
@JsonPropertyOrder({ IdpPolicyRuleActionIdp.JSON_PROPERTY_PROVIDERS,
        IdpPolicyRuleActionIdp.JSON_PROPERTY_IDP_SELECTION_TYPE, IdpPolicyRuleActionIdp.JSON_PROPERTY_MATCH_CRITERIA })
@JsonTypeName("IdpPolicyRuleAction_idp")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class IdpPolicyRuleActionIdp implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PROVIDERS = "providers";
    private List<IdpPolicyRuleActionProvider> providers = null;

    public static final String JSON_PROPERTY_IDP_SELECTION_TYPE = "idpSelectionType";
    private IdpSelectionType idpSelectionType;

    public static final String JSON_PROPERTY_MATCH_CRITERIA = "matchCriteria";
    private List<IdpPolicyRuleActionMatchCriteria> matchCriteria = null;

    public IdpPolicyRuleActionIdp() {
    }

    public IdpPolicyRuleActionIdp providers(List<IdpPolicyRuleActionProvider> providers) {

        this.providers = providers;
        return this;
    }

    public IdpPolicyRuleActionIdp addprovidersItem(IdpPolicyRuleActionProvider providersItem) {
        if (this.providers == null) {
            this.providers = new ArrayList<>();
        }
        this.providers.add(providersItem);
        return this;
    }

    /**
     * List of configured Identity Providers that a given Rule can route to. Ability to define multiple providers is a
     * part of the Okta Identity Engine. This allows users to choose a Provider when they sign in. Contact support for
     * information on the Identity Engine.
     *
     * @return providers
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of configured Identity Providers that a given Rule can route to. Ability to define multiple providers is a part of the Okta Identity Engine. This allows users to choose a Provider when they sign in. Contact support for information on the Identity Engine.")
    @JsonProperty(JSON_PROPERTY_PROVIDERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<IdpPolicyRuleActionProvider> getProviders() {
        return providers;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProviders(List<IdpPolicyRuleActionProvider> providers) {
        this.providers = providers;
    }

    public IdpPolicyRuleActionIdp idpSelectionType(IdpSelectionType idpSelectionType) {

        this.idpSelectionType = idpSelectionType;
        return this;
    }

    /**
     * Get idpSelectionType
     *
     * @return idpSelectionType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_IDP_SELECTION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdpSelectionType getIdpSelectionType() {
        return idpSelectionType;
    }

    @JsonProperty(JSON_PROPERTY_IDP_SELECTION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdpSelectionType(IdpSelectionType idpSelectionType) {
        this.idpSelectionType = idpSelectionType;
    }

    public IdpPolicyRuleActionIdp matchCriteria(List<IdpPolicyRuleActionMatchCriteria> matchCriteria) {

        this.matchCriteria = matchCriteria;
        return this;
    }

    public IdpPolicyRuleActionIdp addmatchCriteriaItem(IdpPolicyRuleActionMatchCriteria matchCriteriaItem) {
        if (this.matchCriteria == null) {
            this.matchCriteria = new ArrayList<>();
        }
        this.matchCriteria.add(matchCriteriaItem);
        return this;
    }

    /**
     * Required if &#x60;idpSelectionType&#x60; is set to &#x60;DYNAMIC&#x60;
     *
     * @return matchCriteria
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Required if `idpSelectionType` is set to `DYNAMIC`")
    @JsonProperty(JSON_PROPERTY_MATCH_CRITERIA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<IdpPolicyRuleActionMatchCriteria> getMatchCriteria() {
        return matchCriteria;
    }

    @JsonProperty(JSON_PROPERTY_MATCH_CRITERIA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMatchCriteria(List<IdpPolicyRuleActionMatchCriteria> matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdpPolicyRuleActionIdp idpPolicyRuleActionIdp = (IdpPolicyRuleActionIdp) o;
        return Objects.equals(this.providers, idpPolicyRuleActionIdp.providers)
                && Objects.equals(this.idpSelectionType, idpPolicyRuleActionIdp.idpSelectionType)
                && Objects.equals(this.matchCriteria, idpPolicyRuleActionIdp.matchCriteria);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(providers, idpSelectionType, matchCriteria);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdpPolicyRuleActionIdp {\n");
        sb.append("    providers: ").append(toIndentedString(providers)).append("\n");
        sb.append("    idpSelectionType: ").append(toIndentedString(idpSelectionType)).append("\n");
        sb.append("    matchCriteria: ").append(toIndentedString(matchCriteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
