package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentitySourceUserProfileForUpsert;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * BulkUpsertRequestBodyProfilesInner
 */
@JsonPropertyOrder({ BulkUpsertRequestBodyProfilesInner.JSON_PROPERTY_EXTERNAL_ID,
        BulkUpsertRequestBodyProfilesInner.JSON_PROPERTY_PROFILE })
@JsonTypeName("BulkUpsertRequestBody_profiles_inner")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class BulkUpsertRequestBodyProfilesInner implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private IdentitySourceUserProfileForUpsert profile;

    public BulkUpsertRequestBodyProfilesInner() {
    }

    public BulkUpsertRequestBodyProfilesInner externalId(String externalId) {

        this.externalId = externalId;
        return this;
    }

    /**
     * The external ID of the entity that needs to be created or updated in Okta
     *
     * @return externalId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The external ID of the entity that needs to be created or updated in Okta")
    @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExternalId() {
        return externalId;
    }

    @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public BulkUpsertRequestBodyProfilesInner profile(IdentitySourceUserProfileForUpsert profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentitySourceUserProfileForUpsert getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(IdentitySourceUserProfileForUpsert profile) {
        this.profile = profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BulkUpsertRequestBodyProfilesInner bulkUpsertRequestBodyProfilesInner = (BulkUpsertRequestBodyProfilesInner) o;
        return Objects.equals(this.externalId, bulkUpsertRequestBodyProfilesInner.externalId)
                && Objects.equals(this.profile, bulkUpsertRequestBodyProfilesInner.profile);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(externalId, profile);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkUpsertRequestBodyProfilesInner {\n");
        sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
