package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * BookmarkApplicationSettingsApplication
 */
@JsonPropertyOrder({ BookmarkApplicationSettingsApplication.JSON_PROPERTY_REQUEST_INTEGRATION,
        BookmarkApplicationSettingsApplication.JSON_PROPERTY_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class BookmarkApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_REQUEST_INTEGRATION = "requestIntegration";
    private Boolean requestIntegration = false;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public BookmarkApplicationSettingsApplication() {
    }

    public BookmarkApplicationSettingsApplication requestIntegration(Boolean requestIntegration) {

        this.requestIntegration = requestIntegration;
        return this;
    }

    /**
     * Would you like Okta to add an integration for this app?
     *
     * @return requestIntegration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Would you like Okta to add an integration for this app?")
    @JsonProperty(JSON_PROPERTY_REQUEST_INTEGRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRequestIntegration() {
        return requestIntegration;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST_INTEGRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequestIntegration(Boolean requestIntegration) {
        this.requestIntegration = requestIntegration;
    }

    public BookmarkApplicationSettingsApplication url(String url) {

        this.url = url;
        return this;
    }

    /**
     * The URL of the launch page for this app
     *
     * @return url
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The URL of the launch page for this app")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BookmarkApplicationSettingsApplication bookmarkApplicationSettingsApplication = (BookmarkApplicationSettingsApplication) o;
        return Objects.equals(this.requestIntegration, bookmarkApplicationSettingsApplication.requestIntegration)
                && Objects.equals(this.url, bookmarkApplicationSettingsApplication.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestIntegration, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookmarkApplicationSettingsApplication {\n");
        sb.append("    requestIntegration: ").append(toIndentedString(requestIntegration)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
