package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationEmbedded;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationLinks;
import com.okta.sdk.resource.model.ApplicationSignOnMode;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.AutoLoginApplicationSettings;
import com.okta.sdk.resource.model.SchemeApplicationCredentials;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AutoLoginApplication
 */
@JsonPropertyOrder({ AutoLoginApplication.JSON_PROPERTY_CREDENTIALS, AutoLoginApplication.JSON_PROPERTY_NAME,
        AutoLoginApplication.JSON_PROPERTY_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "signOnMode", visible = true, defaultImpl = AutoLoginApplication.class)

public class AutoLoginApplication extends Application implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SchemeApplicationCredentials credentials;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private AutoLoginApplicationSettings settings;

    public AutoLoginApplication() {
    }

    /*
     * @JsonCreator public AutoLoginApplication(
     *
     * @JsonProperty(JSON_PROPERTY_NAME) String name,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_ORN) String orn ) { this(); this.name = name; this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.orn = orn; }
     */

    public AutoLoginApplication credentials(SchemeApplicationCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SchemeApplicationCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    /**
     * A unique key is generated for the custom SWA app instance when you use AUTO_LOGIN &#x60;signOnMode&#x60;.
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A unique key is generated for the custom SWA app instance when you use AUTO_LOGIN `signOnMode`.")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    public AutoLoginApplication settings(AutoLoginApplicationSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AutoLoginApplicationSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(AutoLoginApplicationSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AutoLoginApplication autoLoginApplication = (AutoLoginApplication) o;
        return Objects.equals(this.credentials, autoLoginApplication.credentials)
                && Objects.equals(this.name, autoLoginApplication.name)
                && Objects.equals(this.settings, autoLoginApplication.settings);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentials, name, settings, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoLoginApplication {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
