package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationFeatureLinks;
import com.okta.sdk.resource.model.ApplicationFeatureType;
import com.okta.sdk.resource.model.EnabledStatus;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The Feature object is used to configure app feature settings.
 */
@ApiModel(description = "The Feature object is used to configure app feature settings. ")
@JsonPropertyOrder({ ApplicationFeature.JSON_PROPERTY_DESCRIPTION, ApplicationFeature.JSON_PROPERTY_NAME,
        ApplicationFeature.JSON_PROPERTY_STATUS, ApplicationFeature.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "name", visible = true, defaultImpl = ApplicationFeature.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = InboundProvisioningApplicationFeature.class, name = "INBOUND_PROVISIONING"),
        @JsonSubTypes.Type(value = UserProvisioningApplicationFeature.class, name = "USER_PROVISIONING"), })

public class ApplicationFeature implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_NAME = "name";
    protected ApplicationFeatureType name;

    public static final String JSON_PROPERTY_STATUS = "status";
    private EnabledStatus status;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private ApplicationFeatureLinks links;

    public ApplicationFeature() {
    }

    /*
     * @JsonCreator public ApplicationFeature(
     *
     * @JsonProperty(JSON_PROPERTY_DESCRIPTION) String description ) { this(); this.description = description; }
     */

    /**
     * Description of the feature
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Settings for provisioning users from Okta to a downstream app", value = "Description of the feature")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    public ApplicationFeature name(ApplicationFeatureType name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationFeatureType getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(ApplicationFeatureType name) {
        this.name = name;
    }

    public ApplicationFeature status(EnabledStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnabledStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(EnabledStatus status) {
        this.status = status;
    }

    public ApplicationFeature links(ApplicationFeatureLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationFeatureLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ApplicationFeatureLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationFeature applicationFeature = (ApplicationFeature) o;
        return Objects.equals(this.description, applicationFeature.description)
                && Objects.equals(this.name, applicationFeature.name)
                && Objects.equals(this.status, applicationFeature.status)
                && Objects.equals(this.links, applicationFeature.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, name, status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationFeature {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
