package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The template used to generate the username when the app is assigned through a group or directly to a user
 */
@ApiModel(description = "The template used to generate the username when the app is assigned through a group or directly to a user")
@JsonPropertyOrder({ ApplicationCredentialsUsernameTemplate.JSON_PROPERTY_PUSH_STATUS,
        ApplicationCredentialsUsernameTemplate.JSON_PROPERTY_TEMPLATE,
        ApplicationCredentialsUsernameTemplate.JSON_PROPERTY_TYPE,
        ApplicationCredentialsUsernameTemplate.JSON_PROPERTY_USER_SUFFIX })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationCredentialsUsernameTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Determines if the username is pushed to the app on updates for CUSTOM &#x60;type&#x60;
     */
    public enum PushStatusEnum {
        PUSH(String.valueOf("PUSH")),

        DONT_PUSH(String.valueOf("DONT_PUSH")),

        NOT_CONFIGURED(String.valueOf("NOT_CONFIGURED")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        PushStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static PushStatusEnum fromValue(String value) {
            for (PushStatusEnum b : PushStatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_PUSH_STATUS = "pushStatus";
    private PushStatusEnum pushStatus;

    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private String template = "${source.login}";

    /**
     * Type of mapping expression. Empty string is allowed.
     */
    public enum TypeEnum {
        NONE(String.valueOf("NONE")),

        BUILT_IN(String.valueOf("BUILT_IN")),

        CUSTOM(String.valueOf("CUSTOM")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.BUILT_IN;

    public static final String JSON_PROPERTY_USER_SUFFIX = "userSuffix";
    private String userSuffix;

    public ApplicationCredentialsUsernameTemplate() {
    }

    public ApplicationCredentialsUsernameTemplate pushStatus(PushStatusEnum pushStatus) {

        this.pushStatus = pushStatus;
        return this;
    }

    /**
     * Determines if the username is pushed to the app on updates for CUSTOM &#x60;type&#x60;
     *
     * @return pushStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines if the username is pushed to the app on updates for CUSTOM `type`")
    @JsonProperty(JSON_PROPERTY_PUSH_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PushStatusEnum getPushStatus() {
        return pushStatus;
    }

    @JsonProperty(JSON_PROPERTY_PUSH_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPushStatus(PushStatusEnum pushStatus) {
        this.pushStatus = pushStatus;
    }

    public ApplicationCredentialsUsernameTemplate template(String template) {

        this.template = template;
        return this;
    }

    /**
     * Mapping expression used to generate usernames. The following are supported mapping expressions that are used with
     * the &#x60;BUILT_IN&#x60; template type: | Name | Template Expression | | ------------------------------- |
     * ---------------------------------------------- | | AD Employee ID | &#x60;${source.employeeID}&#x60; | | AD SAM
     * Account Name | &#x60;${source.samAccountName}&#x60; | | AD SAM Account Name (lowercase) |
     * &#x60;${fn:toLowerCase(source.samAccountName)}&#x60; | | AD User Principal Name | &#x60;${source.userName}&#x60;
     * | | AD User Principal Name prefix | &#x60;${fn:substringBefore(source.userName, \&quot;@\&quot;)}&#x60; | | Email
     * | &#x60;${source.email}&#x60; | | Email (lowercase) | &#x60;${fn:toLowerCase(source.email)}&#x60; | | Email
     * prefix | &#x60;${fn:substringBefore(source.email, \&quot;@\&quot;)}&#x60; | | LDAP UID + custom suffix |
     * &#x60;${source.userName}${instance.userSuffix}&#x60; | | Okta username | &#x60;${source.login}&#x60; | | Okta
     * username prefix | &#x60;${fn:substringBefore(source.login, \&quot;@\&quot;)}&#x60; |
     *
     * @return template
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Mapping expression used to generate usernames.  The following are supported mapping expressions that are used with the `BUILT_IN` template type:  | Name                            | Template Expression                            | | ------------------------------- | ---------------------------------------------- | | AD Employee ID                  | `${source.employeeID}`                         | | AD SAM Account Name             | `${source.samAccountName}`                     | | AD SAM Account Name (lowercase) | `${fn:toLowerCase(source.samAccountName)}`     | | AD User Principal Name          | `${source.userName}`                           | | AD User Principal Name prefix   | `${fn:substringBefore(source.userName, \"@\")}`  | | Email                           | `${source.email}`                              | | Email (lowercase)               | `${fn:toLowerCase(source.email)}`              | | Email prefix                    | `${fn:substringBefore(source.email, \"@\")}`     | | LDAP UID + custom suffix        | `${source.userName}${instance.userSuffix}`     | | Okta username                   | `${source.login}`                              | | Okta username prefix            | `${fn:substringBefore(source.login, \"@\")}`     |")
    @JsonProperty(JSON_PROPERTY_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTemplate() {
        return template;
    }

    @JsonProperty(JSON_PROPERTY_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTemplate(String template) {
        this.template = template;
    }

    public ApplicationCredentialsUsernameTemplate type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * Type of mapping expression. Empty string is allowed.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of mapping expression. Empty string is allowed.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ApplicationCredentialsUsernameTemplate userSuffix(String userSuffix) {

        this.userSuffix = userSuffix;
        return this;
    }

    /**
     * An optional suffix appended to usernames for &#x60;BUILT_IN&#x60; mapping expressions
     *
     * @return userSuffix
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An optional suffix appended to usernames for `BUILT_IN` mapping expressions")
    @JsonProperty(JSON_PROPERTY_USER_SUFFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserSuffix() {
        return userSuffix;
    }

    @JsonProperty(JSON_PROPERTY_USER_SUFFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserSuffix(String userSuffix) {
        this.userSuffix = userSuffix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationCredentialsUsernameTemplate applicationCredentialsUsernameTemplate = (ApplicationCredentialsUsernameTemplate) o;
        return Objects.equals(this.pushStatus, applicationCredentialsUsernameTemplate.pushStatus)
                && Objects.equals(this.template, applicationCredentialsUsernameTemplate.template)
                && Objects.equals(this.type, applicationCredentialsUsernameTemplate.type)
                && Objects.equals(this.userSuffix, applicationCredentialsUsernameTemplate.userSuffix);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(pushStatus, template, type, userSuffix);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationCredentialsUsernameTemplate {\n");
        sb.append("    pushStatus: ").append(toIndentedString(pushStatus)).append("\n");
        sb.append("    template: ").append(toIndentedString(template)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    userSuffix: ").append(toIndentedString(userSuffix)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
