package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApiTokenNetwork;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * An API Token Update Object for an Okta user. This token is NOT scoped any further and can be used for any API that
 * the user has permissions to call.
 */
@ApiModel(description = "An API Token Update Object for an Okta user. This token is NOT scoped any further and can be used for any API that the user has permissions to call.")
@JsonPropertyOrder({ ApiTokenUpdate.JSON_PROPERTY_CLIENT_NAME, ApiTokenUpdate.JSON_PROPERTY_CREATED,
        ApiTokenUpdate.JSON_PROPERTY_NAME, ApiTokenUpdate.JSON_PROPERTY_NETWORK, ApiTokenUpdate.JSON_PROPERTY_USER_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApiTokenUpdate implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_NAME = "clientName";
    private String clientName;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_NETWORK = "network";
    private ApiTokenNetwork network;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public ApiTokenUpdate() {
    }

    /*
     * @JsonCreator public ApiTokenUpdate(
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_NAME) String clientName,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created ) { this(); this.clientName = clientName;
     * this.created = created; }
     */

    /**
     * The client name associated with the API Token
     *
     * @return clientName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The client name associated with the API Token")
    @JsonProperty(JSON_PROPERTY_CLIENT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientName() {
        return clientName;
    }

    /**
     * The creation date of the API Token
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The creation date of the API Token")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public ApiTokenUpdate name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name associated with the API Token
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name associated with the API Token")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ApiTokenUpdate network(ApiTokenNetwork network) {

        this.network = network;
        return this;
    }

    /**
     * Get network
     *
     * @return network
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApiTokenNetwork getNetwork() {
        return network;
    }

    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(ApiTokenNetwork network) {
        this.network = network;
    }

    public ApiTokenUpdate userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * The userId of the user who created the API Token
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The userId of the user who created the API Token")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApiTokenUpdate apiTokenUpdate = (ApiTokenUpdate) o;
        return Objects.equals(this.clientName, apiTokenUpdate.clientName)
                && Objects.equals(this.created, apiTokenUpdate.created)
                && Objects.equals(this.name, apiTokenUpdate.name)
                && Objects.equals(this.network, apiTokenUpdate.network)
                && Objects.equals(this.userId, apiTokenUpdate.userId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientName, created, name, network, userId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTokenUpdate {\n");
        sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    network: ").append(toIndentedString(network)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
