/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ResourceSetBindingCreateRequest;
import com.okta.sdk.resource.model.ResourceSetBindingResponse;
import com.okta.sdk.resource.model.ResourceSetBindings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleDResourceSetBindingApi {

    private ApiClient apiClient;

    public RoleDResourceSetBindingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleDResourceSetBindingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Role Resource Set Binding Creates a Binding for the Resource Set, Custom Role, and members (Users or
     * Groups)
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param instance
     *            (required)
     *
     * @return ResourceSetBindingResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingResponse createResourceSetBinding(String resourceSetIdOrLabel,
            ResourceSetBindingCreateRequest instance) throws ApiException {
        return this.createResourceSetBinding(resourceSetIdOrLabel, instance, Collections.emptyMap());
    }

    /**
     * Create a Role Resource Set Binding Creates a Binding for the Resource Set, Custom Role, and members (Users or
     * Groups)
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSetBindingResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingResponse createResourceSetBinding(String resourceSetIdOrLabel,
            ResourceSetBindingCreateRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling createResourceSetBinding");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'instance' when calling createResourceSetBinding");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings".replaceAll(
                "\\{" + "resourceSetIdOrLabel" + "\\}", apiClient.escapeString(resourceSetIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Role Resource Set Binding Deletes a Binding of a Role (identified by &#x60;roleIdOrLabel&#x60;) and a
     * Resource Set (identified by &#x60;resourceSetIdOrLabel&#x60;)
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBinding(String resourceSetIdOrLabel, String roleIdOrLabel) throws ApiException {
        this.deleteBinding(resourceSetIdOrLabel, roleIdOrLabel, Collections.emptyMap());
    }

    /**
     * Delete a Role Resource Set Binding Deletes a Binding of a Role (identified by &#x60;roleIdOrLabel&#x60;) and a
     * Resource Set (identified by &#x60;resourceSetIdOrLabel&#x60;)
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBinding(String resourceSetIdOrLabel, String roleIdOrLabel, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling deleteBinding");
        }

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling deleteBinding");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}"
                .replaceAll("\\{" + "resourceSetIdOrLabel" + "\\}",
                        apiClient.escapeString(resourceSetIdOrLabel.toString()))
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Role Resource Set Binding Retrieves the Binding of a Role (identified by &#x60;roleIdOrLabel&#x60;) in
     * a Resource Set (identified by &#x60;resourceSetIdOrLabel&#x60;)
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     *
     * @return ResourceSetBindingResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingResponse getBinding(String resourceSetIdOrLabel, String roleIdOrLabel)
            throws ApiException {
        return this.getBinding(resourceSetIdOrLabel, roleIdOrLabel, Collections.emptyMap());
    }

    /**
     * Retrieve a Role Resource Set Binding Retrieves the Binding of a Role (identified by &#x60;roleIdOrLabel&#x60;) in
     * a Resource Set (identified by &#x60;resourceSetIdOrLabel&#x60;)
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSetBindingResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingResponse getBinding(String resourceSetIdOrLabel, String roleIdOrLabel,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling getBinding");
        }

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling getBinding");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}"
                .replaceAll("\\{" + "resourceSetIdOrLabel" + "\\}",
                        apiClient.escapeString(resourceSetIdOrLabel.toString()))
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Role Resource Set Bindings Lists all Bindings for a Resource Set with pagination support
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return ResourceSetBindings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindings listBindings(String resourceSetIdOrLabel, String after) throws ApiException {
        return this.listBindings(resourceSetIdOrLabel, after, Collections.emptyMap());
    }

    /**
     * List all Role Resource Set Bindings Lists all Bindings for a Resource Set with pagination support
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSetBindings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindings listBindings(String resourceSetIdOrLabel, String after,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling listBindings");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings".replaceAll(
                "\\{" + "resourceSetIdOrLabel" + "\\}", apiClient.escapeString(resourceSetIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSetBindings> localVarReturnType = new TypeReference<ResourceSetBindings>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
