/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Org2Org app instance properties")
@JsonPropertyOrder(value={"acsUrl", "audRestriction", "baseUrl", "creationState", "preferUsernameOverEmail", "token", "tokenEncrypted"})
public class Org2OrgApplicationSettingsApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACS_URL = "acsUrl";
    private String acsUrl;
    public static final String JSON_PROPERTY_AUD_RESTRICTION = "audRestriction";
    private String audRestriction;
    public static final String JSON_PROPERTY_BASE_URL = "baseUrl";
    private String baseUrl;
    public static final String JSON_PROPERTY_CREATION_STATE = "creationState";
    private String creationState;
    public static final String JSON_PROPERTY_PREFER_USERNAME_OVER_EMAIL = "preferUsernameOverEmail";
    private Boolean preferUsernameOverEmail;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_TOKEN_ENCRYPTED = "tokenEncrypted";
    private String tokenEncrypted;

    public Org2OrgApplicationSettingsApplication acsUrl(String acsUrl) {
        this.acsUrl = acsUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Assertion Consumer Service (ACS) URL of the source org (for `SAML_2_0` sign-on mode)")
    @JsonProperty(value="acsUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcsUrl() {
        return this.acsUrl;
    }

    @JsonProperty(value="acsUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcsUrl(String acsUrl) {
        this.acsUrl = acsUrl;
    }

    public Org2OrgApplicationSettingsApplication audRestriction(String audRestriction) {
        this.audRestriction = audRestriction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.okta.com/saml2/service-provider/exampleid", value="The entity ID of the SP (for `SAML_2_0` sign-on mode)")
    @JsonProperty(value="audRestriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudRestriction() {
        return this.audRestriction;
    }

    @JsonProperty(value="audRestriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudRestriction(String audRestriction) {
        this.audRestriction = audRestriction;
    }

    public Org2OrgApplicationSettingsApplication baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The base URL of the target Okta org (for `SAML_2_0` sign-on mode)")
    @JsonProperty(value="baseUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @JsonProperty(value="baseUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Org2OrgApplicationSettingsApplication creationState(String creationState) {
        this.creationState = creationState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to track and manage the state of the app's creation or the provisioning process between two Okta orgs")
    @JsonProperty(value="creationState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreationState() {
        return this.creationState;
    }

    @JsonProperty(value="creationState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationState(String creationState) {
        this.creationState = creationState;
    }

    public Org2OrgApplicationSettingsApplication preferUsernameOverEmail(Boolean preferUsernameOverEmail) {
        this.preferUsernameOverEmail = preferUsernameOverEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that you don't want to use an email address as the username")
    @JsonProperty(value="preferUsernameOverEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreferUsernameOverEmail() {
        return this.preferUsernameOverEmail;
    }

    @JsonProperty(value="preferUsernameOverEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreferUsernameOverEmail(Boolean preferUsernameOverEmail) {
        this.preferUsernameOverEmail = preferUsernameOverEmail;
    }

    public Org2OrgApplicationSettingsApplication token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An API token from the target org that's used to secure the connection between the orgs")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    public Org2OrgApplicationSettingsApplication tokenEncrypted(String tokenEncrypted) {
        this.tokenEncrypted = tokenEncrypted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Encrypted token to enhance security")
    @JsonProperty(value="tokenEncrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenEncrypted() {
        return this.tokenEncrypted;
    }

    @JsonProperty(value="tokenEncrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEncrypted(String tokenEncrypted) {
        this.tokenEncrypted = tokenEncrypted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Org2OrgApplicationSettingsApplication org2OrgApplicationSettingsApplication = (Org2OrgApplicationSettingsApplication)o;
        return Objects.equals(this.acsUrl, org2OrgApplicationSettingsApplication.acsUrl) && Objects.equals(this.audRestriction, org2OrgApplicationSettingsApplication.audRestriction) && Objects.equals(this.baseUrl, org2OrgApplicationSettingsApplication.baseUrl) && Objects.equals(this.creationState, org2OrgApplicationSettingsApplication.creationState) && Objects.equals(this.preferUsernameOverEmail, org2OrgApplicationSettingsApplication.preferUsernameOverEmail) && Objects.equals(this.token, org2OrgApplicationSettingsApplication.token) && Objects.equals(this.tokenEncrypted, org2OrgApplicationSettingsApplication.tokenEncrypted);
    }

    public int hashCode() {
        return Objects.hash(this.acsUrl, this.audRestriction, this.baseUrl, this.creationState, this.preferUsernameOverEmail, this.token, this.tokenEncrypted);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Org2OrgApplicationSettingsApplication {\n");
        sb.append("    acsUrl: ").append(this.toIndentedString(this.acsUrl)).append("\n");
        sb.append("    audRestriction: ").append(this.toIndentedString(this.audRestriction)).append("\n");
        sb.append("    baseUrl: ").append(this.toIndentedString(this.baseUrl)).append("\n");
        sb.append("    creationState: ").append(this.toIndentedString(this.creationState)).append("\n");
        sb.append("    preferUsernameOverEmail: ").append(this.toIndentedString(this.preferUsernameOverEmail)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenEncrypted: ").append(this.toIndentedString(this.tokenEncrypted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

