/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"action", "created", "excludeZones", "lastUpdated", "_links"})
public class ThreatInsightConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACTION = "action";
    private ActionEnum action;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_EXCLUDE_ZONES = "excludeZones";
    private List<String> excludeZones = null;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public ThreatInsightConfiguration action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="none", required=true, value="Specifies how Okta responds to authentication requests from suspicious IP addresses")
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ActionEnum getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAction(ActionEnum action) {
        this.action = action;
    }

    @Nullable
    @ApiModelProperty(example="2020-08-05T22:18:30.629Z", value="Timestamp when the ThreatInsight Configuration object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public ThreatInsightConfiguration excludeZones(List<String> excludeZones) {
        this.excludeZones = excludeZones;
        return this;
    }

    public ThreatInsightConfiguration addexcludeZonesItem(String excludeZonesItem) {
        if (this.excludeZones == null) {
            this.excludeZones = new ArrayList<String>();
        }
        this.excludeZones.add(excludeZonesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="Accepts a list of [Network Zone](/openapi/okta-management/management/tag/NetworkZone/) IDs. IPs in the excluded network zones aren't logged or blocked. This ensures that traffic from known, trusted IPs isn't accidentally logged or blocked.")
    @JsonProperty(value="excludeZones")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExcludeZones() {
        return this.excludeZones;
    }

    @JsonProperty(value="excludeZones")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeZones(List<String> excludeZones) {
        this.excludeZones = excludeZones;
    }

    @Nullable
    @ApiModelProperty(example="2020-09-08T20:53:20.882Z", value="Timestamp when the ThreatInsight Configuration object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public ThreatInsightConfiguration links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreatInsightConfiguration threatInsightConfiguration = (ThreatInsightConfiguration)o;
        return Objects.equals((Object)this.action, (Object)threatInsightConfiguration.action) && Objects.equals(this.created, threatInsightConfiguration.created) && Objects.equals(this.excludeZones, threatInsightConfiguration.excludeZones) && Objects.equals(this.lastUpdated, threatInsightConfiguration.lastUpdated) && Objects.equals(this.links, threatInsightConfiguration.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.created, this.excludeZones, this.lastUpdated, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreatInsightConfiguration {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    excludeZones: ").append(this.toIndentedString(this.excludeZones)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        NONE(String.valueOf("none")),
        AUDIT(String.valueOf("audit")),
        BLOCK(String.valueOf("block")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

