/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Rules for matching and creating users")
@JsonPropertyOrder(value={"allowPartialMatch", "autoActivateNewUsers", "autoConfirmExactMatch", "autoConfirmNewUsers", "autoConfirmPartialMatch", "exactMatchCriteria"})
public class CapabilitiesImportRulesUserCreateAndMatchObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALLOW_PARTIAL_MATCH = "allowPartialMatch";
    private Boolean allowPartialMatch;
    public static final String JSON_PROPERTY_AUTO_ACTIVATE_NEW_USERS = "autoActivateNewUsers";
    private Boolean autoActivateNewUsers;
    public static final String JSON_PROPERTY_AUTO_CONFIRM_EXACT_MATCH = "autoConfirmExactMatch";
    private Boolean autoConfirmExactMatch;
    public static final String JSON_PROPERTY_AUTO_CONFIRM_NEW_USERS = "autoConfirmNewUsers";
    private Boolean autoConfirmNewUsers;
    public static final String JSON_PROPERTY_AUTO_CONFIRM_PARTIAL_MATCH = "autoConfirmPartialMatch";
    private Boolean autoConfirmPartialMatch;
    public static final String JSON_PROPERTY_EXACT_MATCH_CRITERIA = "exactMatchCriteria";
    private ExactMatchCriteriaEnum exactMatchCriteria;

    public CapabilitiesImportRulesUserCreateAndMatchObject allowPartialMatch(Boolean allowPartialMatch) {
        this.allowPartialMatch = allowPartialMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows user import upon partial matching. Partial matching occurs when the first and last names of an imported user match those of an existing Okta user, even if the username or email attributes don't match.")
    @JsonProperty(value="allowPartialMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowPartialMatch() {
        return this.allowPartialMatch;
    }

    @JsonProperty(value="allowPartialMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowPartialMatch(Boolean allowPartialMatch) {
        this.allowPartialMatch = allowPartialMatch;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoActivateNewUsers(Boolean autoActivateNewUsers) {
        this.autoActivateNewUsers = autoActivateNewUsers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, imported new users are automatically activated.")
    @JsonProperty(value="autoActivateNewUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoActivateNewUsers() {
        return this.autoActivateNewUsers;
    }

    @JsonProperty(value="autoActivateNewUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoActivateNewUsers(Boolean autoActivateNewUsers) {
        this.autoActivateNewUsers = autoActivateNewUsers;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoConfirmExactMatch(Boolean autoConfirmExactMatch) {
        this.autoConfirmExactMatch = autoConfirmExactMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, exact-matched users are automatically confirmed on activation. If set to `false`, exact-matched users need to be confirmed manually.")
    @JsonProperty(value="autoConfirmExactMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoConfirmExactMatch() {
        return this.autoConfirmExactMatch;
    }

    @JsonProperty(value="autoConfirmExactMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoConfirmExactMatch(Boolean autoConfirmExactMatch) {
        this.autoConfirmExactMatch = autoConfirmExactMatch;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoConfirmNewUsers(Boolean autoConfirmNewUsers) {
        this.autoConfirmNewUsers = autoConfirmNewUsers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, imported new users are automatically confirmed on activation. This doesn't apply to imported users that already exist in Okta.")
    @JsonProperty(value="autoConfirmNewUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoConfirmNewUsers() {
        return this.autoConfirmNewUsers;
    }

    @JsonProperty(value="autoConfirmNewUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoConfirmNewUsers(Boolean autoConfirmNewUsers) {
        this.autoConfirmNewUsers = autoConfirmNewUsers;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoConfirmPartialMatch(Boolean autoConfirmPartialMatch) {
        this.autoConfirmPartialMatch = autoConfirmPartialMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, partially matched users are automatically confirmed on activation. If set to `false`, partially matched users need to be confirmed manually.")
    @JsonProperty(value="autoConfirmPartialMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoConfirmPartialMatch() {
        return this.autoConfirmPartialMatch;
    }

    @JsonProperty(value="autoConfirmPartialMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoConfirmPartialMatch(Boolean autoConfirmPartialMatch) {
        this.autoConfirmPartialMatch = autoConfirmPartialMatch;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject exactMatchCriteria(ExactMatchCriteriaEnum exactMatchCriteria) {
        this.exactMatchCriteria = exactMatchCriteria;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines the attribute to match users")
    @JsonProperty(value="exactMatchCriteria")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExactMatchCriteriaEnum getExactMatchCriteria() {
        return this.exactMatchCriteria;
    }

    @JsonProperty(value="exactMatchCriteria")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExactMatchCriteria(ExactMatchCriteriaEnum exactMatchCriteria) {
        this.exactMatchCriteria = exactMatchCriteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilitiesImportRulesUserCreateAndMatchObject capabilitiesImportRulesUserCreateAndMatchObject = (CapabilitiesImportRulesUserCreateAndMatchObject)o;
        return Objects.equals(this.allowPartialMatch, capabilitiesImportRulesUserCreateAndMatchObject.allowPartialMatch) && Objects.equals(this.autoActivateNewUsers, capabilitiesImportRulesUserCreateAndMatchObject.autoActivateNewUsers) && Objects.equals(this.autoConfirmExactMatch, capabilitiesImportRulesUserCreateAndMatchObject.autoConfirmExactMatch) && Objects.equals(this.autoConfirmNewUsers, capabilitiesImportRulesUserCreateAndMatchObject.autoConfirmNewUsers) && Objects.equals(this.autoConfirmPartialMatch, capabilitiesImportRulesUserCreateAndMatchObject.autoConfirmPartialMatch) && Objects.equals((Object)this.exactMatchCriteria, (Object)capabilitiesImportRulesUserCreateAndMatchObject.exactMatchCriteria);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowPartialMatch, this.autoActivateNewUsers, this.autoConfirmExactMatch, this.autoConfirmNewUsers, this.autoConfirmPartialMatch, this.exactMatchCriteria});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilitiesImportRulesUserCreateAndMatchObject {\n");
        sb.append("    allowPartialMatch: ").append(this.toIndentedString(this.allowPartialMatch)).append("\n");
        sb.append("    autoActivateNewUsers: ").append(this.toIndentedString(this.autoActivateNewUsers)).append("\n");
        sb.append("    autoConfirmExactMatch: ").append(this.toIndentedString(this.autoConfirmExactMatch)).append("\n");
        sb.append("    autoConfirmNewUsers: ").append(this.toIndentedString(this.autoConfirmNewUsers)).append("\n");
        sb.append("    autoConfirmPartialMatch: ").append(this.toIndentedString(this.autoConfirmPartialMatch)).append("\n");
        sb.append("    exactMatchCriteria: ").append(this.toIndentedString((Object)this.exactMatchCriteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExactMatchCriteriaEnum {
        EMAIL(String.valueOf("EMAIL")),
        USERNAME(String.valueOf("USERNAME")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ExactMatchCriteriaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExactMatchCriteriaEnum fromValue(String value) {
            for (ExactMatchCriteriaEnum b : ExactMatchCriteriaEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

