/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AuthenticatorType {
    APP("app"),
    EMAIL("email"),
    FEDERATED("federated"),
    PASSWORD("password"),
    PHONE("phone"),
    SECURITY_KEY("security_key"),
    SECURITY_QUESTION("security_question"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private AuthenticatorType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AuthenticatorType fromValue(String value) {
        for (AuthenticatorType b : AuthenticatorType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString().toString());
    }
}

