/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "value"})
@JsonTypeName(value="UserImportResponse_commands_inner")
public class UserImportResponseCommandsInner
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Map<String, String> value = null;

    public UserImportResponseCommandsInner type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The command types supported for the import inline hook. When using the `com.okta.action.update` command to specify that the user should be treated as a match, you need to also provide a `com.okta.user.update` command that sets the ID of the Okta user.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UserImportResponseCommandsInner value(Map<String, String> value) {
        this.value = value;
        return this;
    }

    public UserImportResponseCommandsInner putvalueItem(String key, String valueItem) {
        if (this.value == null) {
            this.value = new HashMap<String, String>();
        }
        this.value.put(key, valueItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `value` object is the parameter to pass to the command. In the case of the `com.okta.appUser.profile.update` and `com.okta.user.profile.update` commands,  the parameter should be a list of one or more profile attributes and the values you wish to set them to. In the case of the `com.okta.action.update` command, the parameter should be a `result` property set to either `CREATE_USER` or `LINK_USER`.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Map<String, String> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserImportResponseCommandsInner userImportResponseCommandsInner = (UserImportResponseCommandsInner)o;
        return Objects.equals((Object)this.type, (Object)userImportResponseCommandsInner.type) && Objects.equals(this.value, userImportResponseCommandsInner.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportResponseCommandsInner {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        APP_USER_PROFILE_UPDATE("com.okta.appUser.profile.update"),
        USER_PROFILE_UPDATE("com.okta.user.profile.update"),
        ACTION_UPDATE("com.okta.action.update"),
        USER_UPDATE("com.okta.user.update"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

