/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"activationToken", "activationUrl"})
public class UserActivationToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACTIVATION_TOKEN = "activationToken";
    private String activationToken;
    public static final String JSON_PROPERTY_ACTIVATION_URL = "activationUrl";
    private String activationUrl;

    @Nullable
    @ApiModelProperty(example="XE6wE17zmphl3KqAPFxO", value="Token received as part of an activation user request. If a password was set before the user was activated, then user must sign in with their password or the `activationToken` and not the activation link. More information about using the `activationToken` to login can be found in the [Authentication API](https://developer.okta.com/docs/reference/api/authn/#primary-authentication-with-activation-token).")
    @JsonProperty(value="activationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActivationToken() {
        return this.activationToken;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}/welcome/XE6wE17zmphl3KqAPFxO", value="If `sendEmail` is `false`, returns an activation link for the user to set up their account. The activation token can be used to create a custom activation link.")
    @JsonProperty(value="activationUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActivationUrl() {
        return this.activationUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserActivationToken userActivationToken = (UserActivationToken)o;
        return Objects.equals(this.activationToken, userActivationToken.activationToken) && Objects.equals(this.activationUrl, userActivationToken.activationUrl);
    }

    public int hashCode() {
        return Objects.hash(this.activationToken, this.activationUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserActivationToken {\n");
        sb.append("    activationToken: ").append(this.toIndentedString(this.activationToken)).append("\n");
        sb.append("    activationUrl: ").append(this.toIndentedString(this.activationUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

