/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.Org2OrgApplicationSettings;
import com.okta.sdk.resource.model.SchemeApplicationCredentials;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Schema for the Okta Org2Org app (key name: `okta_org2org`)  To create an Org2Org app, use the [Create an Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication) request with the following parameters in the request body. > **Notes:**  > * The Okta Org2Org (`okta_org2org`) app isn't available in Okta Developer Edition orgs. If you need to test this feature in your Developer Edition org, contact your Okta account team. > * The Okta Org2Org app supports `SAML_2_0` and `AUTO_LOGIN` sign-on modes. ")
@JsonPropertyOrder(value={"accessibility", "credentials", "label", "licensing", "name", "profile", "signOnMode", "status", "visibility", "settings"})
public class Org2OrgApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
    private ApplicationAccessibility accessibility;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SchemeApplicationCredentials credentials;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LICENSING = "licensing";
    private ApplicationLicensing licensing;
    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    private SignOnModeEnum signOnMode = SignOnModeEnum.SAML_2_0;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationLifecycleStatus status;
    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private ApplicationVisibility visibility;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private Org2OrgApplicationSettings settings;

    public Org2OrgApplication accessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationAccessibility getAccessibility() {
        return this.accessibility;
    }

    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
    }

    public Org2OrgApplication credentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SchemeApplicationCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    public Org2OrgApplication label(String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="User-defined display name for app")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public Org2OrgApplication licensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLicensing getLicensing() {
        return this.licensing;
    }

    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
    }

    public Org2OrgApplication name(NameEnum name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="okta_org2org", required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameEnum getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public Org2OrgApplication profile(Map<String, Object> profile) {
        this.profile = profile;
        return this;
    }

    public Org2OrgApplication putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<String, Object>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps)")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public Org2OrgApplication signOnMode(SignOnModeEnum signOnMode) {
        this.signOnMode = signOnMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SignOnModeEnum getSignOnMode() {
        return this.signOnMode;
    }

    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnMode(SignOnModeEnum signOnMode) {
        this.signOnMode = signOnMode;
    }

    public Org2OrgApplication status(ApplicationLifecycleStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLifecycleStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ApplicationLifecycleStatus status) {
        this.status = status;
    }

    public Org2OrgApplication visibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationVisibility getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
    }

    public Org2OrgApplication settings(Org2OrgApplicationSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Org2OrgApplicationSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSettings(Org2OrgApplicationSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Org2OrgApplication org2OrgApplication = (Org2OrgApplication)o;
        return Objects.equals(this.accessibility, org2OrgApplication.accessibility) && Objects.equals(this.credentials, org2OrgApplication.credentials) && Objects.equals(this.label, org2OrgApplication.label) && Objects.equals(this.licensing, org2OrgApplication.licensing) && Objects.equals((Object)this.name, (Object)org2OrgApplication.name) && Objects.equals(this.profile, org2OrgApplication.profile) && Objects.equals((Object)this.signOnMode, (Object)org2OrgApplication.signOnMode) && Objects.equals((Object)this.status, (Object)org2OrgApplication.status) && Objects.equals(this.visibility, org2OrgApplication.visibility) && Objects.equals(this.settings, org2OrgApplication.settings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessibility, this.credentials, this.label, this.licensing, this.name, this.profile, this.signOnMode, this.status, this.visibility, this.settings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Org2OrgApplication {\n");
        sb.append("    accessibility: ").append(this.toIndentedString(this.accessibility)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    licensing: ").append(this.toIndentedString(this.licensing)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    signOnMode: ").append(this.toIndentedString((Object)this.signOnMode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SignOnModeEnum {
        SAML_2_0("SAML_2_0"),
        AUTO_LOGIN("AUTO_LOGIN"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private SignOnModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SignOnModeEnum fromValue(String value) {
            for (SignOnModeEnum b : SignOnModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum NameEnum {
        OKTA_ORG2ORG("okta_org2org"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

