/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Endpoint for the JSON Web Key Set (JWKS) document. This document contains signing keys that are used to validate the signatures from the provider. For more information on JWKS, see [JSON Web Key](https://tools.ietf.org/html/rfc7517).")
@JsonPropertyOrder(value={"binding", "url"})
public class OidcJwksEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public OidcJwksEndpoint binding(ProtocolEndpointBinding binding) {
        this.binding = binding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="binding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolEndpointBinding getBinding() {
        return this.binding;
    }

    @JsonProperty(value="binding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public OidcJwksEndpoint url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://idp.example.com/keys", value="URL of the endpoint to the JWK Set")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OidcJwksEndpoint oidcJwksEndpoint = (OidcJwksEndpoint)o;
        return Objects.equals((Object)this.binding, (Object)oidcJwksEndpoint.binding) && Objects.equals(this.url, oidcJwksEndpoint.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.binding, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OidcJwksEndpoint {\n");
        sb.append("    binding: ").append(this.toIndentedString((Object)this.binding)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

